"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorCheckable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/constants");
var _platinum_license_popover = require("../../shared/platinum_license_popover/platinum_license_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCss = (euiTheme, isDisabled, showNativeBadge) => {
  return (0, _react2.css)`
    ${showNativeBadge && `box-shadow: 8px 9px 0px -1px ${euiTheme.colors.lightestShade},
      8px 9px 0px 0px ${euiTheme.colors.lightShade};`}
    ${isDisabled && `background-color: ${euiTheme.colors.lightestShade};
    color: ${euiTheme.colors.disabledText};
    `}
  `;
};
const ConnectorCheckable = ({
  isDisabled,
  documentationUrl,
  iconType,
  isBeta,
  isTechPreview,
  name,
  onConnectorSelect,
  serviceType,
  showNativeBadge
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isLicensePopoverOpen, setIsLicensePopoverOpen] = (0, _react.useState)(false);
  const [isNativePopoverOpen, setIsNativePopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    onClick: () => {
      if (isDisabled && showNativeBadge) return;
      onConnectorSelect(showNativeBadge);
    },
    id: `checkableCard-${serviceType}`,
    css: getCss(euiTheme, isDisabled, showNativeBadge),
    hasBorder: true,
    "data-telemetry-id": `entSearchContent-connector-selectConnector-${serviceType}-select`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, iconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    size: "l"
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "flexStart",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "disabledText",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, name)) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, name))), isDisabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_platinum_license_popover.PlatinumLicensePopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.selectConnector.openPopoverLabel', {
        defaultMessage: 'Open licensing popover'
      }),
      iconType: "questionInCircle",
      onClick: event => {
        event.preventDefault();
        event.stopPropagation();
        setIsLicensePopoverOpen(!isLicensePopoverOpen);
      }
    }),
    closePopover: () => setIsLicensePopoverOpen(false),
    isPopoverOpen: isLicensePopoverOpen
  })))), showNativeBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      isDisabled: isDisabled,
      color: "primary",
      iconType: "boxesHorizontal",
      onClick: e => {
        e.stopPropagation();
        e.preventDefault();
        setIsNativePopoverOpen(true);
      }
    }),
    isOpen: isNativePopoverOpen,
    closePopover: () => {
      setIsNativePopoverOpen(false);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "xs",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "native",
      onClick: e => {
        e.stopPropagation();
        onConnectorSelect(true);
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorCheckable.setupANativeConnectorContextMenuItemLabel', {
      defaultMessage: 'Setup a Native Connector'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "client",
      onClick: e => {
        e.stopPropagation();
        onConnectorSelect(false);
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorCheckable.setupAConnectorClientContextMenuItemLabel', {
      defaultMessage: 'Setup a Connector Client'
    }))]
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "flexStart",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, showNativeBadge ? _constants.NATIVE_LABEL : _constants.CONNECTOR_CLIENT_LABEL))), isBeta && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _constants.BETA_LABEL))), isTechPreview && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: "beaker"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.connectorCheckable.techPreviewLabel', {
    defaultMessage: 'Tech preview'
  })))))), documentationUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: documentationUrl
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.connectorCheckable.documentationLinkLabel', {
    defaultMessage: 'Documentation'
  }))))))))));
};
exports.ConnectorCheckable = ConnectorCheckable;