"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewSearchIndexTemplate = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _beta_connector_callout = require("../../../shared/beta/beta_connector_callout");
var _constants2 = require("../../../shared/constants");
var _doc_links = require("../../../shared/doc_links");
var _constants3 = require("./constants");
var _new_search_index_logic = require("./new_search_index_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NewSearchIndexTemplate = ({
  buttonLoading,
  disabled,
  error,
  onNameChange,
  onSubmit,
  type,
  isBeta
}) => {
  const {
    fullIndexName,
    fullIndexNameExists,
    fullIndexNameIsValid,
    language,
    rawName,
    languageSelectValue
  } = (0, _kea.useValues)(_new_search_index_logic.NewSearchIndexLogic);
  const {
    setRawName,
    setLanguageSelectValue
  } = (0, _kea.useActions)(_new_search_index_logic.NewSearchIndexLogic);
  const handleNameChange = e => {
    setRawName(e.target.value);
    if (onNameChange) {
      onNameChange(fullIndexName);
    }
  };
  const handleLanguageChange = e => {
    setLanguageSelectValue(e.target.value);
  };
  const formInvalid = !!error || fullIndexNameExists || !fullIndexNameIsValid;
  const formError = () => {
    if (fullIndexNameExists) {
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.alreadyExists.error', {
        defaultMessage: 'An index with the name {indexName} already exists',
        values: {
          indexName: fullIndexName
        }
      });
    }
    if (!fullIndexNameIsValid) {
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.isInvalid.error', {
        defaultMessage: '{indexName} is an invalid index name',
        values: {
          indexName: fullIndexName
        }
      });
    }
    return error;
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    id: "enterprise-search-create-index",
    onSubmit: event => {
      event.preventDefault();
      onSubmit(fullIndexName, language);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, isBeta ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_beta_connector_callout.BetaConnectorCallout, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.formTitle",
    defaultMessage: "Create an Elasticsearch index"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.formDescription",
    defaultMessage: "This index will hold your data source content, and is optimized with default field mappings for relevant search experiences. Give your index a unique name and optionally set a default {language_analyzer} for the index.",
    values: {
      language_analyzer: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: _doc_links.docLinks.languageAnalyzers
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.formDescription.linkText', {
        defaultMessage: 'language analyzer'
      }))
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isDisabled: disabled || buttonLoading,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.nameInputLabel', {
      defaultMessage: 'Index name'
    }),
    isInvalid: formInvalid,
    error: formError(),
    helpText: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.nameInputHelpText.lineOne', {
      defaultMessage: 'Your index will be named: {indexName}',
      values: {
        indexName: fullIndexName
      }
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": `entSearchContent-${type}-newIndex-editName`,
    "data-telemetry-id": `entSearchContent-${type}-newIndex-editName`,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.nameInputPlaceholder', {
      defaultMessage: 'Set a name for your index'
    }),
    fullWidth: true,
    disabled: disabled,
    isInvalid: false,
    value: rawName,
    onChange: handleNameChange,
    autoFocus: true,
    prepend: "search-"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.nameInputHelpText.lineTwo', {
    defaultMessage: 'Names should be lowercase and cannot contain spaces or special characters.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isDisabled: disabled,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.languageInputLabel', {
      defaultMessage: 'Language analyzer'
    }),
    helpText: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.languageInputHelpText', {
      defaultMessage: 'Language can be changed later, but may require a reindex'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-telemetry-id": `entSearchContent-${type}-newIndex-languageAnalyzer`,
    disabled: disabled,
    options: _constants3.SUPPORTED_LANGUAGES,
    onChange: handleLanguageChange,
    value: languageSelectValue
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.elasticsearchGettingStarted
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.learnMoreIndices.linkText', {
    defaultMessage: 'Learn more about indices'
  }))), type === _constants.INGESTION_METHOD_IDS.CONNECTOR && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.connectors
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.learnMoreConnectors.linkText', {
    defaultMessage: 'Learn more about connectors'
  }))), type === _constants.INGESTION_METHOD_IDS.CRAWLER && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.crawlerOverview
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.learnMoreCrawler.linkText', {
    defaultMessage: 'Learn more about the Elastic web crawler'
  }))), type === _constants.INGESTION_METHOD_IDS.API && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.ingestionApis
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.learnMoreApis.linkText', {
    defaultMessage: 'Learn more about ingestion APIs'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": `entSearchContent-${type}-newIndex-goBack`,
    isDisabled: buttonLoading,
    onClick: () => history.back()
  }, _constants2.BACK_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": `entSearchContent-${type}-newIndex-createIndex`,
    "data-telemetry-id": `entSearchContent-${type}-newIndex-createIndex`,
    fill: true,
    isDisabled: !rawName || buttonLoading || formInvalid || disabled,
    isLoading: buttonLoading,
    type: "submit"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.newSearchIndexTemplate.createIndex.buttonText', {
    defaultMessage: 'Create index'
  }))))));
};
exports.NewSearchIndexTemplate = NewSearchIndexTemplate;