"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlerEmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../shared/encode_path_params");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _routes = require("../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlerEmptyState = () => {
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawlerEmptyState.h2.createYourFirstWebLabel', {
      defaultMessage: 'Create your first web crawler'
    })),
    titleSize: "m",
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawlerEmptyState.p.discoverExtractAndIndexLabel', {
      defaultMessage: 'Discover extract and index searchable content from websites and knowledge bases'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      disabled: Boolean(errorConnectingMessage),
      fill: true,
      iconType: "plusInCircle",
      onClick: () => _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.NEW_INDEX_METHOD_PATH, {
        type: 'crawler'
      }))
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawlerEmptyState.newWebCrawlerButtonLabel', {
      defaultMessage: 'New web crawler'
    }))
  }));
};
exports.CrawlerEmptyState = CrawlerEmptyState;