"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _fetch_sync_jobs_stats_api_logic = require("../../api/stats/fetch_sync_jobs_stats_api_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorStats = ({
  isCrawler
}) => {
  const {
    makeRequest
  } = (0, _kea.useActions)(_fetch_sync_jobs_stats_api_logic.FetchSyncJobsStatsApiLogic);
  const {
    data
  } = (0, _kea.useValues)(_fetch_sync_jobs_stats_api_logic.FetchSyncJobsStatsApiLogic);
  (0, _react.useEffect)(() => {
    makeRequest({
      isCrawler
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.h4.connectorSummaryLabel', {
    defaultMessage: 'Connector summary'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.h4.crawlerSummaryLabel', {
    defaultMessage: 'Web crawler summary'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.connectorsTextLabel', {
    defaultMessage: '{count} connectors',
    values: {
      count: ((data === null || data === void 0 ? void 0 : data.connected) || 0) + ((data === null || data === void 0 ? void 0 : data.incomplete) || 0)
    }
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.crawlersTextLabel', {
    defaultMessage: '{count} web crawlers',
    values: {
      count: ((data === null || data === void 0 ? void 0 : data.connected) || 0) + ((data === null || data === void 0 ? void 0 : data.incomplete) || 0)
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.connectedBadgeLabel', {
    defaultMessage: '{number} connected',
    values: {
      number: (data === null || data === void 0 ? void 0 : data.connected) || 0
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.incompleteBadgeLabel', {
    defaultMessage: '{number} incomplete',
    values: {
      number: (data === null || data === void 0 ? void 0 : data.incomplete) || 0
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.h4.syncsStatusLabel', {
    defaultMessage: 'Syncs status'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.runningSyncsTextLabel', {
    defaultMessage: '{syncs} running syncs',
    values: {
      syncs: data === null || data === void 0 ? void 0 : data.in_progress
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.idleSyncsOrphanedSyncsLabel', {
    defaultMessage: '{idleCount} Idle syncs  / {orphanedCount} Orphaned syncs / {errorCount} Sync errors',
    values: {
      errorCount: (data === null || data === void 0 ? void 0 : data.errors) || 0,
      idleCount: data === null || data === void 0 ? void 0 : data.idle,
      orphanedCount: data === null || data === void 0 ? void 0 : data.orphaned_jobs
    }
  })))));
};
exports.ConnectorStats = ConnectorStats;