"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSyncJobsStats = exports.FetchSyncJobsStatsApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSyncJobsStats = async ({
  isCrawler
}) => {
  const route = '/internal/enterprise_search/stats/sync_jobs';
  const options = isCrawler !== undefined ? {
    query: {
      isCrawler
    }
  } : undefined;
  return await _http.HttpLogic.values.http.get(route, options);
};
exports.fetchSyncJobsStats = fetchSyncJobsStats;
const FetchSyncJobsStatsApiLogic = (0, _create_api_logic.createApiLogic)(['enterprise_search_content', 'fetch_sync_jobs_stats_api_logic'], fetchSyncJobsStats);
exports.FetchSyncJobsStatsApiLogic = FetchSyncJobsStatsApiLogic;