"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startE5MultilingualModel = exports.StartE5MultilingualModelApiLogic = void 0;
var _create_api_logic = require("../../../../shared/api_logic/create_api_logic");
var _http = require("../../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const startE5MultilingualModel = async ({
  modelId
}) => {
  const route = `/internal/enterprise_search/ml/models/${modelId}/deploy`;
  return await _http.HttpLogic.values.http.post(route);
};
exports.startE5MultilingualModel = startE5MultilingualModel;
const StartE5MultilingualModelApiLogic = (0, _create_api_logic.createApiLogic)(['start_e5_multilingual_model_api_logic'], startE5MultilingualModel, {
  showErrorFlash: false
});
exports.StartE5MultilingualModelApiLogic = StartE5MultilingualModelApiLogic;