"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.recreateCrawlerConnector = exports.RecreateCrawlerConnectorApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const recreateCrawlerConnector = async ({
  indexName
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/crawler/connector`;
  return await _http.HttpLogic.values.http.post(route);
};
exports.recreateCrawlerConnector = recreateCrawlerConnector;
const RecreateCrawlerConnectorApiLogic = (0, _create_api_logic.createApiLogic)(['recreate_crawler_connector_api_logic'], recreateCrawlerConnector);
exports.RecreateCrawlerConnectorApiLogic = RecreateCrawlerConnectorApiLogic;