"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBoostSummary = void 0;
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBoostSummary = boost => {
  if (boost.type === _types.BoostType.Value) {
    return !boost.value ? '' : boost.value.filter(v => v.trim() !== '').join(',');
  } else if (boost.type === _types.BoostType.Proximity) {
    return boost.function || '';
  } else {
    return [boost.function || '', boost.operation || ''].join(' ').trim();
  }
};
exports.getBoostSummary = getBoostSummary;