"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutomatedCurationsHistoryPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../../../common/constants");
var _log_stream = require("../../../../../../shared/log_stream");
var _data_panel = require("../../../../data_panel");
var _engine = require("../../../../engine");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutomatedCurationsHistoryPanel = () => {
  const {
    engineName
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const [endTimestamp, setEndTimestamp] = (0, _react.useState)(Date.now());
  const filters = ['event.kind: event', 'event.dataset: search-relevance-suggestions', `appsearch.adaptive_relevance.engine: ${engineName}`, 'event.action: curation_suggestion', 'appsearch.adaptive_relevance.suggestion.new_status: automated'];
  return /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    iconType: "tableDensityNormal",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      component: "h2"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.automatedCurationsHistoryPanel.tableTitle', {
      defaultMessage: 'Adaptive relevance changes'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      component: "span",
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "refresh",
      size: "xs",
      onClick: () => setEndTimestamp(Date.now())
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.curations.refreshButton', {
      defaultMessage: 'Refresh'
    })))),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.automatedCurationsHistoryPanel.tableDecription', {
      defaultMessage: 'A detailed log of recent changes to curations powered by adaptive relevance.'
    }),
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_log_stream.EntSearchLogStream, {
    logView: {
      type: 'log-view-reference',
      logViewId: _constants.ENTERPRISE_SEARCH_RELEVANCE_LOGS_SOURCE_ID
    },
    hoursAgo: 720,
    query: filters.join(' and '),
    endTimestamp: endTimestamp,
    columns: [{
      type: 'field',
      field: 'appsearch.adaptive_relevance.query',
      header: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.automatedCurationsHistoryPanel.queryColumnHeader', {
        defaultMessage: 'Query'
      })
    }, {
      type: 'timestamp'
    }, {
      type: 'message'
    }]
  }));
};
exports.AutomatedCurationsHistoryPanel = AutomatedCurationsHistoryPanel;