"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _icons = require("../../../../shared/icons");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _use_local_storage = require("../../../../shared/use_local_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SuggestionsCallout = ({
  title,
  description,
  buttonTo,
  lastUpdatedTimestamp,
  style
}) => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const [lastDismissedTimestamp, setLastDismissedTimestamp] = (0, _use_local_storage.useLocalStorage)(`suggestions-callout--${pathname}`, new Date(0).toISOString());
  if (new Date(lastDismissedTimestamp) >= new Date(lastUpdatedTimestamp)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    style: style,
    color: "success",
    iconType: _icons.LightbulbIcon,
    title: title
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    to: buttonTo,
    color: "success",
    fill: true,
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestionsCallout.reviewSuggestionsButtonLabel', {
    defaultMessage: 'Review suggestions'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "success",
    iconType: "eyeClosed",
    size: "s",
    onClick: () => {
      setLastDismissedTimestamp(new Date().toISOString());
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestionsCallout.hideForNowLabel', {
    defaultMessage: 'Hide this for now'
  }))))));
};
exports.SuggestionsCallout = SuggestionsCallout;