"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageCrawlsPopoverLogic = void 0;
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _flash_messages = require("../../../../../shared/flash_messages");
var _http = require("../../../../../shared/http");
var _engine = require("../../../engine");
var _crawler_logic = require("../../crawler_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManageCrawlsPopoverLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'crawler', 'manage_crawls_popover'],
  actions: () => ({
    closePopover: true,
    reApplyCrawlRules: domain => ({
      domain
    }),
    togglePopover: true
  }),
  reducers: () => ({
    isOpen: [false, {
      closePopover: () => false,
      togglePopover: currentIsOpen => !currentIsOpen
    }]
  }),
  listeners: ({
    actions
  }) => ({
    reApplyCrawlRules: async ({
      domain
    }) => {
      const {
        engineName
      } = _engine.EngineLogic.values;
      const {
        http
      } = _http.HttpLogic.values;
      const requestBody = {};
      if (domain) {
        requestBody.domains = [domain.url];
      }
      try {
        await http.post(`/internal/app_search/engines/${engineName}/crawler/process_crawls`, {
          body: JSON.stringify(requestBody)
        });
        (0, _flash_messages.flashSuccessToast)(_i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.manageCrawlsPopover.reApplyCrawlRules.successMessage', {
          defaultMessage: 'Crawl rules are being re-applied in the background'
        }));
        _crawler_logic.CrawlerLogic.actions.fetchCrawlerData();
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      } finally {
        actions.closePopover();
      }
    }
  })
});
exports.ManageCrawlsPopoverLogic = ManageCrawlsPopoverLogic;