"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiLogs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _engine = require("../engine");
var _layout = require("../layout");
var _log_retention = require("../log_retention");
var _api_log = require("./api_log");
var _components = require("./components");
var _constants = require("./constants");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiLogs = () => {
  const {
    dataLoading,
    apiLogs,
    meta
  } = (0, _kea.useValues)(_.ApiLogsLogic);
  const {
    fetchApiLogs,
    pollForApiLogs
  } = (0, _kea.useActions)(_.ApiLogsLogic);
  (0, _react.useEffect)(() => {
    fetchApiLogs();
  }, [meta.page.current]);
  (0, _react.useEffect)(() => {
    pollForApiLogs();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_constants.API_LOGS_TITLE]),
    pageHeader: {
      pageTitle: _constants.API_LOGS_TITLE
    },
    isLoading: dataLoading && !apiLogs.length,
    isEmptyState: !apiLogs.length,
    emptyState: /*#__PURE__*/_react.default.createElement(_components.EmptyState, null)
  }, /*#__PURE__*/_react.default.createElement(_log_retention.LogRetentionCallout, {
    type: _log_retention.LogRetentionOptions.API
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _constants.RECENT_API_EVENTS))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_log_retention.LogRetentionTooltip, {
    type: _log_retention.LogRetentionOptions.API
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.NewApiEventsPrompt, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_components.ApiLogsTable, {
    hasPagination: true
  }), /*#__PURE__*/_react.default.createElement(_api_log.ApiLogFlyout, null)));
};
exports.ApiLogs = ApiLogs;