"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppLogic = void 0;
var _kea = require("kea");
var _licensing = require("../shared/licensing");
var _role = require("./utils/role");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AppLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'app_logic'],
  actions: {
    setOnboardingComplete: () => true
  },
  reducers: ({
    props
  }) => ({
    account: [props.appSearch, {
      setOnboardingComplete: account => ({
        ...account,
        onboardingComplete: true
      })
    }],
    configuredLimits: [props.configuredLimits.appSearch, {}]
  }),
  selectors: {
    myRole: [selectors => [selectors.account, _licensing.LicensingLogic.selectors.hasPlatinumLicense], ({
      role
    }) => role ? (0, _role.getRoleAbilities)(role) : {}]
  }
});
exports.AppLogic = AppLogic;