"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeRangeContainer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _ = require("../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * interfaces are not allowed to specify a sub-set of the required types until
 * https://github.com/microsoft/TypeScript/issues/15300 is fixed so we use a type
 * here instead
 */

const TIME_RANGE_CONTAINER = 'TIME_RANGE_CONTAINER';
class TimeRangeContainer extends _.Container {
  constructor(initialInput, getFactory, parent) {
    super(initialInput, {
      embeddableLoaded: {}
    }, getFactory, parent);
    (0, _defineProperty2.default)(this, "type", TIME_RANGE_CONTAINER);
  }
  getAllDataViews() {
    return [];
  }
  getInheritedInput() {
    return {
      timeRange: this.input.timeRange
    };
  }
  render() {}
  reload() {}
}
exports.TimeRangeContainer = TimeRangeContainer;