"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DescriptiveContactCardEmbeddableFactory = exports.DESCRIPTIVE_CONTACT_CARD_EMBEDDABLE = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _contact_card_embeddable = require("./contact_card_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DESCRIPTIVE_CONTACT_CARD_EMBEDDABLE = 'DESCRIPTIVE_CONTACT_CARD_EMBEDDABLE';
exports.DESCRIPTIVE_CONTACT_CARD_EMBEDDABLE = DESCRIPTIVE_CONTACT_CARD_EMBEDDABLE;
class DescriptiveContactCardEmbeddableFactory {
  constructor(execTrigger) {
    (0, _defineProperty2.default)(this, "type", DESCRIPTIVE_CONTACT_CARD_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "create", async (initialInput, parent) => {
      return new _contact_card_embeddable.ContactCardEmbeddable(initialInput, {
        execAction: this.execTrigger,
        outputOverrides: {
          defaultDescription: 'This is a family friend'
        }
      }, parent);
    });
    this.execTrigger = execTrigger;
  }
  async isEditable() {
    return true;
  }
  getDisplayName() {
    return 'descriptive contact card';
  }
}
exports.DescriptiveContactCardEmbeddableFactory = DescriptiveContactCardEmbeddableFactory;