"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usageCollection = exports.untilPluginStartServicesReady = exports.uiActions = exports.setKibanaServices = exports.savedObjectsTaggingOss = exports.savedObjectsManagement = exports.inspector = exports.embeddableStart = exports.core = exports.contentManagement = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let core;
exports.core = core;
let embeddableStart;
exports.embeddableStart = embeddableStart;
let uiActions;
exports.uiActions = uiActions;
let inspector;
exports.inspector = inspector;
let usageCollection;
exports.usageCollection = usageCollection;
let savedObjectsManagement;
exports.savedObjectsManagement = savedObjectsManagement;
let savedObjectsTaggingOss;
exports.savedObjectsTaggingOss = savedObjectsTaggingOss;
let contentManagement;
exports.contentManagement = contentManagement;
const servicesReady$ = new _rxjs.BehaviorSubject(false);
const untilPluginStartServicesReady = () => {
  if (servicesReady$.value) return Promise.resolve();
  return new Promise(resolve => {
    const subscription = servicesReady$.subscribe(isInitialized => {
      if (isInitialized) {
        subscription.unsubscribe();
        resolve();
      }
    });
  });
};
exports.untilPluginStartServicesReady = untilPluginStartServicesReady;
const setKibanaServices = (kibanaCore, selfStart, deps) => {
  exports.core = core = kibanaCore;
  exports.uiActions = uiActions = deps.uiActions;
  exports.inspector = inspector = deps.inspector;
  exports.embeddableStart = embeddableStart = selfStart;
  exports.usageCollection = usageCollection = deps.usageCollection;
  exports.savedObjectsManagement = savedObjectsManagement = deps.savedObjectsManagement;
  exports.savedObjectsTaggingOss = savedObjectsTaggingOss = deps.savedObjectsTaggingOss;
  exports.contentManagement = contentManagement = deps.contentManagement;
  servicesReady$.next(true);
};
exports.setKibanaServices = setKibanaServices;