"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEmbeddablePanel = void 0;
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _kibana_services = require("../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const useEmbeddablePanel = ({
  embeddable
}) => {
  const {
    loading,
    value
  } = (0, _useAsync.default)(async () => {
    const startServicesPromise = (0, _kibana_services.untilPluginStartServicesReady)();
    const modulePromise = Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable_panel')));
    const embeddablePromise = typeof embeddable === 'function' ? embeddable() : Promise.resolve(embeddable);
    const [, unwrappedEmbeddable, panelModule] = await Promise.all([startServicesPromise, embeddablePromise, modulePromise]);
    return {
      panelModule,
      unwrappedEmbeddable
    };
  }, []);
  if (loading || !(value !== null && value !== void 0 && value.panelModule) || !(value !== null && value !== void 0 && value.unwrappedEmbeddable)) return;
  return {
    unwrappedEmbeddable: value.unwrappedEmbeddable,
    Panel: value.panelModule.EmbeddablePanel
  };
};
exports.useEmbeddablePanel = useEmbeddablePanel;