"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddablePanelTitle = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lib = require("../../lib");
var _embeddable_panel_strings = require("../embeddable_panel_strings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EmbeddablePanelTitle = ({
  viewMode,
  hideTitle,
  embeddable,
  description,
  customizePanelAction
}) => {
  const title = embeddable.getTitle();
  const titleComponent = (0, _react.useMemo)(() => {
    if (hideTitle) return null;
    const titleClassNames = (0, _classnames.default)('embPanel__titleText', {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      embPanel__placeholderTitleText: !title
    });
    if (viewMode === _lib.ViewMode.VIEW) {
      return /*#__PURE__*/_react.default.createElement("span", {
        className: titleClassNames
      }, title);
    }
    if (customizePanelAction) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        color: "text",
        className: titleClassNames,
        "aria-label": (0, _embeddable_panel_strings.getEditTitleAriaLabel)(title),
        "data-test-subj": 'embeddablePanelTitleLink',
        onClick: () => customizePanelAction.execute({
          embeddable
        })
      }, title || _embeddable_panel_strings.placeholderTitle);
    }
    return null;
  }, [customizePanelAction, embeddable, title, viewMode, hideTitle]);
  const titleComponentWithDescription = (0, _react.useMemo)(() => {
    if (!description) return /*#__PURE__*/_react.default.createElement("span", {
      className: "embPanel__titleInner"
    }, titleComponent);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: description,
      delay: "regular",
      position: "top",
      anchorClassName: "embPanel__titleTooltipAnchor"
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "embPanel__titleInner"
    }, titleComponent, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "iInCircle",
      color: "subdued",
      "data-test-subj": "embeddablePanelTitleDescriptionIcon"
    })));
  }, [description, titleComponent]);
  return titleComponentWithDescription;
};
exports.EmbeddablePanelTitle = EmbeddablePanelTitle;