"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomizePanelEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _can_inherit_time_range = require("./can_inherit_time_range");
var _does_inherit_time_range = require("./does_inherit_time_range");
var _lib = require("../../../lib");
var _filters_details = require("./filters_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CustomizePanelEditor = props => {
  var _embeddable$getInput$, _embeddable$getInput$2;
  const {
    onClose,
    embeddable,
    dateFormat,
    timeRangeCompatible,
    onEdit
  } = props;
  const editMode = embeddable.getInput().viewMode === _lib.ViewMode.EDIT;
  const [hideTitle, setHideTitle] = (0, _react.useState)(embeddable.getInput().hidePanelTitles);
  const [panelDescription, setPanelDescription] = (0, _react.useState)((_embeddable$getInput$ = embeddable.getInput().description) !== null && _embeddable$getInput$ !== void 0 ? _embeddable$getInput$ : embeddable.getOutput().defaultDescription);
  const [panelTitle, setPanelTitle] = (0, _react.useState)((_embeddable$getInput$2 = embeddable.getInput().title) !== null && _embeddable$getInput$2 !== void 0 ? _embeddable$getInput$2 : embeddable.getOutput().defaultTitle);
  const [inheritTimeRange, setInheritTimeRange] = (0, _react.useState)(timeRangeCompatible ? (0, _does_inherit_time_range.doesInheritTimeRange)(embeddable) : false);
  const [panelTimeRange, setPanelTimeRange] = (0, _react.useState)(timeRangeCompatible ? embeddable.getInput().timeRange : undefined);
  const commonlyUsedRangesForDatePicker = props.commonlyUsedRanges ? props.commonlyUsedRanges.map(({
    from,
    to,
    display
  }) => {
    return {
      start: from,
      end: to,
      label: display
    };
  }) : undefined;
  const save = () => {
    const newPanelSettings = {
      hidePanelTitles: hideTitle,
      title: panelTitle === embeddable.getOutput().defaultTitle ? undefined : panelTitle,
      description: panelDescription === embeddable.getOutput().defaultDescription ? undefined : panelDescription
    };
    if (Boolean(timeRangeCompatible)) newPanelSettings.timeRange = !inheritTimeRange ? panelTimeRange : undefined;
    embeddable.updateInput(newPanelSettings);
    onClose();
  };
  const renderCustomTitleComponent = () => {
    if (!editMode) return null;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      checked: !hideTitle,
      "data-test-subj": "customEmbeddablePanelHideTitleSwitch",
      disabled: !editMode,
      id: "hideTitle",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Show title",
        id: "embeddableApi.customizePanel.flyout.optionsMenuForm.showTitle"
      }),
      onChange: e => setHideTitle(!e.target.checked)
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "embeddableApi.customizePanel.flyout.optionsMenuForm.panelTitleFormRowLabel",
        defaultMessage: "Title"
      }),
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        "data-test-subj": "resetCustomEmbeddablePanelTitleButton",
        onClick: () => setPanelTitle(embeddable.getOutput().defaultTitle),
        disabled: hideTitle || !editMode || embeddable.getOutput().defaultTitle === panelTitle,
        "aria-label": _i18n.i18n.translate('embeddableApi.customizePanel.flyout.optionsMenuForm.resetCustomTitleButtonAriaLabel', {
          defaultMessage: 'Reset title'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "embeddableApi.customizePanel.flyout.optionsMenuForm.resetCustomTitleButtonLabel",
        defaultMessage: "Reset"
      }))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      id: "panelTitleInput",
      className: "panelTitleInputText",
      "data-test-subj": "customEmbeddablePanelTitleInput",
      name: "title",
      type: "text",
      disabled: hideTitle || !editMode,
      value: panelTitle !== null && panelTitle !== void 0 ? panelTitle : '',
      onChange: e => setPanelTitle(e.target.value),
      "aria-label": _i18n.i18n.translate('embeddableApi.customizePanel.flyout.optionsMenuForm.panelTitleInputAriaLabel', {
        defaultMessage: 'Enter a custom title for your panel'
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "embeddableApi.customizePanel.flyout.optionsMenuForm.panelDescriptionFormRowLabel",
        defaultMessage: "Description"
      }),
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        "data-test-subj": "resetCustomEmbeddablePanelDescriptionButton",
        onClick: () => {
          setPanelDescription(embeddable.getOutput().defaultDescription);
        },
        disabled: hideTitle || !editMode || embeddable.getOutput().defaultDescription === panelDescription,
        "aria-label": _i18n.i18n.translate('embeddableApi.customizePanel.flyout.optionsMenuForm.resetCustomDescriptionButtonAriaLabel', {
          defaultMessage: 'Reset description'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "embeddableApi.customizePanel.modal.optionsMenuForm.resetCustomDescriptionButtonLabel",
        defaultMessage: "Reset"
      }))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      id: "panelDescriptionInput",
      className: "panelDescriptionInputText",
      "data-test-subj": "customEmbeddablePanelDescriptionInput",
      disabled: hideTitle || !editMode,
      name: "description",
      value: panelDescription !== null && panelDescription !== void 0 ? panelDescription : '',
      onChange: e => setPanelDescription(e.target.value),
      "aria-label": _i18n.i18n.translate('embeddableApi.customizePanel.flyout.optionsMenuForm.panelDescriptionAriaLabel', {
        defaultMessage: 'Enter a custom description for your panel'
      })
    })));
  };
  const renderCustomTimeRangeComponent = () => {
    var _panelTimeRange$from, _panelTimeRange$to;
    if (!timeRangeCompatible) return null;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _can_inherit_time_range.canInheritTimeRange)(embeddable) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      checked: !inheritTimeRange,
      "data-test-subj": "customizePanelShowCustomTimeRange",
      id: "showCustomTimeRange",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Apply custom time range",
        id: "embeddableApi.customizePanel.flyout.optionsMenuForm.showCustomTimeRangeSwitch"
      }),
      onChange: e => setInheritTimeRange(!e.target.checked)
    })) : null, !inheritTimeRange ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "embeddableApi.customizePanel.flyout.optionsMenuForm.panelTimeRangeFormRowLabel",
        defaultMessage: "Time range"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
      start: (_panelTimeRange$from = panelTimeRange === null || panelTimeRange === void 0 ? void 0 : panelTimeRange.from) !== null && _panelTimeRange$from !== void 0 ? _panelTimeRange$from : undefined,
      end: (_panelTimeRange$to = panelTimeRange === null || panelTimeRange === void 0 ? void 0 : panelTimeRange.to) !== null && _panelTimeRange$to !== void 0 ? _panelTimeRange$to : undefined,
      onTimeChange: ({
        start,
        end
      }) => setPanelTimeRange({
        from: start,
        to: end
      }),
      showUpdateButton: false,
      dateFormat: dateFormat,
      commonlyUsedRanges: commonlyUsedRangesForDatePicker,
      "data-test-subj": "customizePanelTimeRangeDatePicker"
    })) : null);
  };
  const renderFilterDetails = () => {
    if (!(0, _lib.isFilterableEmbeddable)(embeddable)) return null;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_filters_details.FiltersDetails, {
      onEdit: onEdit,
      embeddable: embeddable,
      editMode: editMode
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "embeddableApi.customizePanel.flyout.title",
    defaultMessage: "Panel settings"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, renderCustomTitleComponent(), renderCustomTimeRangeComponent(), renderFilterDetails())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelCustomizePanelButton",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "embeddableApi.customizePanel.flyout.cancelButtonTitle",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "saveCustomizePanelButton",
    onClick: save,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "embeddableApi.customizePanel.flyout.saveButtonTitle",
    defaultMessage: "Apply"
  }))))));
};
exports.CustomizePanelEditor = CustomizePanelEditor;