"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomTimeRangeBadge = exports.CUSTOM_TIME_RANGE_BADGE = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _server = require("react-dom/server");
var _does_inherit_time_range = require("./does_inherit_time_range");
var _customize_panel_action = require("./customize_panel_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CUSTOM_TIME_RANGE_BADGE = 'CUSTOM_TIME_RANGE_BADGE';
exports.CUSTOM_TIME_RANGE_BADGE = CUSTOM_TIME_RANGE_BADGE;
class CustomTimeRangeBadge extends _customize_panel_action.CustomizePanelAction {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "type", CUSTOM_TIME_RANGE_BADGE);
    (0, _defineProperty2.default)(this, "id", CUSTOM_TIME_RANGE_BADGE);
    (0, _defineProperty2.default)(this, "order", 7);
  }
  getDisplayName({
    embeddable
  }) {
    var _this$dateFormat;
    return (0, _server.renderToString)( /*#__PURE__*/_react.default.createElement(_eui.PrettyDuration, {
      timeFrom: embeddable.getInput().timeRange.from,
      timeTo: embeddable.getInput().timeRange.to,
      dateFormat: (_this$dateFormat = this.dateFormat) !== null && _this$dateFormat !== void 0 ? _this$dateFormat : 'Browser'
    }));
  }
  getIconType() {
    return 'calendar';
  }
  async isCompatible({
    embeddable
  }) {
    return Boolean(embeddable && (0, _customize_panel_action.hasTimeRange)(embeddable) && !(0, _does_inherit_time_range.doesInheritTimeRange)(embeddable));
  }
}
exports.CustomTimeRangeBadge = CustomTimeRangeBadge;