"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.placeholderTitle = exports.getEditTitleAriaLabel = exports.getContextMenuAriaLabel = exports.getAriaLabelForTitle = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const placeholderTitle = _i18n.i18n.translate('embeddableApi.panel.placeholderTitle', {
  defaultMessage: '[No Title]'
});
exports.placeholderTitle = placeholderTitle;
const getAriaLabelForTitle = title => {
  if (title) {
    return _i18n.i18n.translate('embeddableApi.panel.enhancedDashboardPanelAriaLabel', {
      defaultMessage: 'Dashboard panel: {title}',
      values: {
        title: title || placeholderTitle
      }
    });
  }
  return _i18n.i18n.translate('embeddableApi.panel.dashboardPanelAriaLabel', {
    defaultMessage: 'Dashboard panel'
  });
};
exports.getAriaLabelForTitle = getAriaLabelForTitle;
const getEditTitleAriaLabel = title => _i18n.i18n.translate('embeddableApi.panel.editTitleAriaLabel', {
  defaultMessage: 'Click to edit title: {title}',
  values: {
    title: title || placeholderTitle
  }
});
exports.getEditTitleAriaLabel = getEditTitleAriaLabel;
const getContextMenuAriaLabel = (title, index) => {
  if (title) {
    return _i18n.i18n.translate('embeddableApi.panel.optionsMenu.panelOptionsButtonEnhancedAriaLabel', {
      defaultMessage: 'Panel options for {title}',
      values: {
        title
      }
    });
  }
  if (index) {
    return _i18n.i18n.translate('embeddableApi.panel.optionsMenu.panelOptionsButtonAriaLabelWithIndex', {
      defaultMessage: 'Options for panel {index}',
      values: {
        index
      }
    });
  }
  return _i18n.i18n.translate('embeddableApi.panel.optionsMenu.panelOptionsButtonAriaLabel', {
    defaultMessage: 'Panel options'
  });
};
exports.getContextMenuAriaLabel = getContextMenuAriaLabel;