"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sizeIsOutOfRange = exports.isRawDataValid = exports.getRawDataOrDefault = exports.MIN_SIZE = exports.MAX_SIZE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_SIZE = 10;
exports.MIN_SIZE = MIN_SIZE;
const MAX_SIZE = 10000;
exports.MAX_SIZE = MAX_SIZE;
// note: this is the type of the "fields" property in the ES response

const isRawDataValid = rawData => typeof rawData === 'object' && Object.keys(rawData).every(x => Array.isArray(rawData[x]));
exports.isRawDataValid = isRawDataValid;
const getRawDataOrDefault = rawData => isRawDataValid(rawData) ? rawData : {};
exports.getRawDataOrDefault = getRawDataOrDefault;
const sizeIsOutOfRange = size => size == null || size < MIN_SIZE || size > MAX_SIZE;
exports.sizeIsOutOfRange = sizeIsOutOfRange;