"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSortForEmbeddable = getSortForEmbeddable;
var _discoverUtils = require("@kbn/discover-utils");
var _sorting = require("../../../common/utils/sorting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * sorting for embeddable, like getSortArray,but returning a default in the case the given sort or dataView is not valid
 */
function getSortForEmbeddable(sort, dataView, uiSettings) {
  if (!sort || !sort.length || !dataView) {
    if (!uiSettings) {
      return [];
    }
    const defaultSortOrder = uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING, 'desc');
    const hidingTimeColumn = uiSettings.get(_discoverUtils.DOC_HIDE_TIME_COLUMN_SETTING, false);
    return (0, _sorting.getDefaultSort)(dataView, defaultSortOrder, hidingTimeColumn);
  }
  return (0, _sorting.getSortArray)(sort, dataView);
}