"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _discoverUtils = require("@kbn/discover-utils");
var _common = require("../common");
var _kibana_services = require("./kibana_services");
var _register_feature = require("./register_feature");
var _build_services = require("./build_services");
var _embeddable = require("./embeddable");
var _view_saved_search_action = require("./embeddable/view_saved_search_action");
var _truncate_styles = require("./utils/truncate_styles");
var _initialize_kbn_url_tracking = require("./utils/initialize_kbn_url_tracking");
var _locator = require("./application/context/services/locator");
var _locator2 = require("./application/doc/locator");
var _profile_registry = require("./customizations/profile_registry");
var _constants = require("./embeddable/constants");
var _discover_container = require("./components/discover_container");
var _search_provider = require("./global_search/search_provider");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
/**
 * @public
 */

/**
 * @internal
 */

/**
 * @internal
 */

/**
 * Contains Discover, one of the oldest parts of Kibana
 * Discover provides embeddables for Dashboards
 */
class DiscoverPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "appStateUpdater", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "stopUrlTracking", undefined);
    (0, _defineProperty2.default)(this, "profileRegistry", (0, _profile_registry.createProfileRegistry)());
    (0, _defineProperty2.default)(this, "locator", void 0);
    (0, _defineProperty2.default)(this, "contextLocator", void 0);
    (0, _defineProperty2.default)(this, "singleDocLocator", void 0);
    (0, _defineProperty2.default)(this, "getDiscoverServices", async (core, plugins) => {
      const {
        locator,
        contextLocator,
        singleDocLocator
      } = await getProfileAwareLocators({
        locator: this.locator,
        contextLocator: this.contextLocator,
        singleDocLocator: this.singleDocLocator
      });
      return (0, _build_services.buildServices)(core, plugins, this.initializerContext, locator, contextLocator, singleDocLocator);
    });
    this.initializerContext = initializerContext;
  }
  setup(core, plugins) {
    const baseUrl = core.http.basePath.prepend('/app/discover');
    const isDev = this.initializerContext.env.mode.dev;
    if (plugins.share) {
      const useHash = core.uiSettings.get('state:storeInSessionStorage');

      // Create locators for external use without profile-awareness
      this.locator = plugins.share.url.locators.create(new _common.DiscoverAppLocatorDefinition({
        useHash,
        setStateToKbnUrl: _public2.setStateToKbnUrl
      }));
      this.contextLocator = plugins.share.url.locators.create(new _locator.DiscoverContextAppLocatorDefinition({
        useHash
      }));
      this.singleDocLocator = plugins.share.url.locators.create(new _locator2.DiscoverSingleDocLocatorDefinition());
    }
    if (plugins.globalSearch) {
      const enableESQL = core.uiSettings.get(_discoverUtils.ENABLE_ESQL);
      plugins.globalSearch.registerResultProvider((0, _search_provider.getESQLSearchProvider)(enableESQL, core.getStartServices().then(([{
        application: {
          capabilities
        }
      }]) => capabilities), core.getStartServices().then(deps => {
        const {
          data
        } = deps[1];
        return data;
      }), this.locator));
    }
    const {
      setTrackedUrl,
      restorePreviousUrl,
      stopUrlTracker,
      appMounted,
      appUnMounted,
      setTrackingEnabled
    } = (0, _initialize_kbn_url_tracking.initializeKbnUrlTracking)(baseUrl, core, this.appStateUpdater, plugins);
    (0, _kibana_services.setUrlTracker)({
      setTrackedUrl,
      restorePreviousUrl,
      setTrackingEnabled
    });
    this.stopUrlTracking = () => {
      stopUrlTracker();
    };
    const appStateUpdater$ = (0, _rxjs.combineLatest)([this.appStateUpdater, this.profileRegistry.getContributedAppState$()]).pipe((0, _rxjs.map)(([urlAppStateUpdater, profileAppStateUpdater]) => app => ({
      ...urlAppStateUpdater(app),
      ...profileAppStateUpdater(app)
    })));
    core.application.register({
      id: _common.PLUGIN_ID,
      title: 'Discover',
      updater$: appStateUpdater$,
      order: 1000,
      euiIconType: 'logoKibana',
      defaultPath: '#/',
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      mount: async params => {
        const [coreStart, discoverStartPlugins] = await core.getStartServices();
        (0, _kibana_services.setScopedHistory)(params.history);
        (0, _kibana_services.setHeaderActionMenuMounter)(params.setHeaderActionMenu);
        (0, _kibana_services.syncHistoryLocations)();
        appMounted();

        // dispatch synthetic hash change event to update hash history objects
        // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
        const unlistenParentHistory = params.history.listen(() => {
          window.dispatchEvent(new HashChangeEvent('hashchange'));
        });
        const {
          locator,
          contextLocator,
          singleDocLocator
        } = await getProfileAwareLocators({
          locator: this.locator,
          contextLocator: this.contextLocator,
          singleDocLocator: this.singleDocLocator
        });
        const services = (0, _build_services.buildServices)(coreStart, discoverStartPlugins, this.initializerContext, locator, contextLocator, singleDocLocator);

        // make sure the data view list is up to date
        await discoverStartPlugins.dataViews.clearCache();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        // FIXME: Temporarily hide overflow-y in Discover app when Field Stats table is shown
        // due to EUI bug https://github.com/elastic/eui/pull/5152
        params.element.classList.add('dscAppWrapper');
        const unmount = renderApp({
          element: params.element,
          services,
          profileRegistry: this.profileRegistry,
          isDev
        });
        return () => {
          unlistenParentHistory();
          unmount();
          appUnMounted();
        };
      }
    });
    plugins.urlForwarding.forwardApp('doc', 'discover', path => {
      return `#${path}`;
    });
    plugins.urlForwarding.forwardApp('context', 'discover', path => {
      const urlParts = path.split('/');
      // take care of urls containing legacy url, those split in the following way
      // ["", "context", indexPatternId, _type, id + params]
      if (urlParts[4]) {
        // remove _type part
        const newPath = [...urlParts.slice(0, 3), ...urlParts.slice(4)].join('/');
        return `#${newPath}`;
      }
      return `#${path}`;
    });
    plugins.urlForwarding.forwardApp('discover', 'discover', path => {
      const [, id, tail] = /discover\/([^\?]+)(.*)/.exec(path) || [];
      if (!id) {
        return `#${path.replace('/discover', '') || '/'}`;
      }
      return `#/view/${id}${tail || ''}`;
    });
    if (plugins.home) {
      (0, _register_feature.registerFeature)(plugins.home);
    }
    this.registerEmbeddable(core, plugins);
    return {
      locator: this.locator
    };
  }
  start(core, plugins) {
    // we need to register the application service at setup, but to render it
    // there are some start dependencies necessary, for this reason
    // initializeServices are assigned at start and used
    // when the application/embeddable is mounted

    const viewSavedSearchAction = new _view_saved_search_action.ViewSavedSearchAction(core.application, this.locator);
    plugins.uiActions.addTriggerAction('CONTEXT_MENU_TRIGGER', viewSavedSearchAction);
    plugins.uiActions.registerTrigger(_constants.SEARCH_EMBEDDABLE_CELL_ACTIONS_TRIGGER);
    (0, _kibana_services.setUiActions)(plugins.uiActions);
    (0, _truncate_styles.injectTruncateStyles)(core.uiSettings.get(_discoverUtils.TRUNCATE_MAX_HEIGHT));
    const isDev = this.initializerContext.env.mode.dev;
    const getDiscoverServicesInternal = () => {
      return this.getDiscoverServices(core, plugins);
    };
    return {
      locator: this.locator,
      DiscoverContainer: props => {
        return /*#__PURE__*/_react.default.createElement(_discover_container.DiscoverContainerInternal, (0, _extends2.default)({
          getDiscoverServices: getDiscoverServicesInternal,
          isDev: isDev
        }, props));
      },
      registerCustomizationProfile: (0, _profile_registry.createRegisterCustomizationProfile)(this.profileRegistry)
    };
  }
  stop() {
    if (this.stopUrlTracking) {
      this.stopUrlTracking();
    }
  }
  registerEmbeddable(core, plugins) {
    const getStartServices = async () => {
      const [coreStart, deps] = await core.getStartServices();
      return {
        executeTriggerActions: deps.uiActions.executeTriggerActions,
        isEditable: () => coreStart.application.capabilities.discover.save
      };
    };
    const getDiscoverServicesInternal = async () => {
      const [coreStart, deps] = await core.getStartServices();
      return this.getDiscoverServices(coreStart, deps);
    };
    const factory = new _embeddable.SearchEmbeddableFactory(getStartServices, getDiscoverServicesInternal);
    plugins.embeddable.registerEmbeddableFactory(factory.type, factory);
  }
}

/**
 * Create profile-aware locators for internal use
 */
exports.DiscoverPlugin = DiscoverPlugin;
const getProfileAwareLocators = async ({
  locator,
  contextLocator,
  singleDocLocator
}) => {
  const {
    ProfileAwareLocator
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./customizations/profile_aware_locator')));
  return {
    locator: new ProfileAwareLocator(locator),
    contextLocator: new ProfileAwareLocator(contextLocator),
    singleDocLocator: new ProfileAwareLocator(singleDocLocator)
  };
};