"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderCustomToolbar = exports.getRenderCustomToolbarWithElements = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
require("./render_custom_toolbar.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const renderCustomToolbar = props => {
  const {
    leftSide,
    bottomSection,
    toolbarProps: {
      hasRoomForGridControls,
      columnControl,
      columnSortingControl,
      fullScreenControl,
      keyboardShortcutsControl,
      displayControl
    },
    gridProps: {
      additionalControls
    }
  } = props;
  const buttons = hasRoomForGridControls ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, leftSide && additionalControls && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "dscGridToolbarControlButton"
  }, additionalControls)), columnControl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "dscGridToolbarControlButton"
  }, columnControl)), columnSortingControl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "dscGridToolbarControlButton"
  }, columnSortingControl)), !leftSide && additionalControls && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "dscGridToolbarControlButton"
  }, additionalControls))) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    justifyContent: "spaceBetween",
    alignItems: "center",
    className: "dscGridToolbar",
    "data-test-subj": "dscGridToolbar",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, leftSide || /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    alignItems: "center"
  }, buttons)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    alignItems: "center"
  }, Boolean(leftSide) && buttons, (keyboardShortcutsControl || displayControl || fullScreenControl) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "dscGridToolbarControlGroup"
  }, keyboardShortcutsControl && /*#__PURE__*/_react.default.createElement("div", {
    className: "dscGridToolbarControlIconButton"
  }, keyboardShortcutsControl), displayControl && /*#__PURE__*/_react.default.createElement("div", {
    className: "dscGridToolbarControlIconButton"
  }, displayControl), fullScreenControl && /*#__PURE__*/_react.default.createElement("div", {
    className: "dscGridToolbarControlIconButton"
  }, fullScreenControl)))))), bottomSection ? /*#__PURE__*/_react.default.createElement("div", {
    className: "dscGridToolbarBottom",
    "data-test-subj": "dscGridToolbarBottom"
  }, bottomSection) : null);
};

/**
 * Render custom element on the left side and all controls to the right
 */
exports.renderCustomToolbar = renderCustomToolbar;
const getRenderCustomToolbarWithElements = ({
  leftSide,
  bottomSection
}) => {
  const reservedSpace = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  return props => renderCustomToolbar({
    ...props,
    leftSide: leftSide || reservedSpace,
    bottomSection
  });
};
exports.getRenderCustomToolbarWithElements = getRenderCustomToolbarWithElements;