"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InternalStateProvider = void 0;
exports.getInternalStateContainer = getInternalStateContainer;
exports.useInternalStateSelector = void 0;
var _common = require("@kbn/kibana-utils-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const {
  Provider: InternalStateProvider,
  useSelector: useInternalStateSelector
} = (0, _common.createStateContainerReactHelpers)();
exports.useInternalStateSelector = useInternalStateSelector;
exports.InternalStateProvider = InternalStateProvider;
function getInternalStateContainer() {
  return (0, _common.createStateContainer)({
    dataView: undefined,
    adHocDataViews: [],
    savedDataViews: [],
    expandedDoc: undefined,
    customFilters: []
  }, {
    setDataView: prevState => nextDataView => ({
      ...prevState,
      dataView: nextDataView
    }),
    setSavedDataViews: prevState => nextDataViewList => ({
      ...prevState,
      savedDataViews: nextDataViewList
    }),
    setAdHocDataViews: prevState => newAdHocDataViewList => ({
      ...prevState,
      adHocDataViews: newAdHocDataViewList
    }),
    appendAdHocDataViews: prevState => dataViewsAdHoc => {
      // check for already existing data views
      const concatList = (Array.isArray(dataViewsAdHoc) ? dataViewsAdHoc : [dataViewsAdHoc]).filter(dataView => {
        return !prevState.adHocDataViews.find(el => el.id === dataView.id);
      });
      if (!concatList.length) {
        return prevState;
      }
      return {
        ...prevState,
        adHocDataViews: prevState.adHocDataViews.concat(dataViewsAdHoc)
      };
    },
    removeAdHocDataViewById: prevState => id => ({
      ...prevState,
      adHocDataViews: prevState.adHocDataViews.filter(dataView => dataView.id !== id)
    }),
    replaceAdHocDataViewWithId: prevState => (prevId, newDataView) => ({
      ...prevState,
      adHocDataViews: prevState.adHocDataViews.map(dataView => dataView.id === prevId ? newDataView : dataView)
    }),
    setExpandedDoc: prevState => expandedDoc => ({
      ...prevState,
      expandedDoc
    }),
    setCustomFilters: prevState => customFilters => ({
      ...prevState,
      customFilters
    })
  }, {}, {
    freeze: state => state
  });
}