"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useContextAppFetch = useContextAppFetch;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _anchor = require("../services/anchor");
var _context = require("../services/context");
var _context_query_state = require("../services/context_query_state");
var _use_discover_services = require("../../../hooks/use_discover_services");
var _get_es_query_sort = require("../../../../common/utils/sorting/get_es_query_sort");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createError = (statusKey, reason, error) => ({
  [statusKey]: {
    value: _context_query_state.LoadingStatus.FAILED,
    error,
    reason
  }
});
function useContextAppFetch({
  anchorId,
  dataView,
  appState,
  useNewFieldsApi
}) {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    uiSettings: config,
    data,
    toastNotifications,
    filterManager
  } = services;
  const searchSource = (0, _react.useMemo)(() => {
    return data.search.searchSource.createEmpty();
  }, [data.search.searchSource]);
  const tieBreakerFieldName = (0, _react.useMemo)(() => (0, _get_es_query_sort.getTieBreakerFieldName)(dataView, config), [config, dataView]);
  const [fetchedState, setFetchedState] = (0, _react.useState)((0, _context_query_state.getInitialContextQueryState)());
  const setState = (0, _react.useCallback)(values => {
    setFetchedState(prevState => ({
      ...prevState,
      ...values
    }));
  }, []);
  const fetchAnchorRow = (0, _react.useCallback)(async () => {
    const errorTitle = _i18n.i18n.translate('discover.context.unableToLoadAnchorDocumentDescription', {
      defaultMessage: 'Unable to load the anchor document'
    });
    if (!tieBreakerFieldName) {
      setState(createError('anchorStatus', _context_query_state.FailureReason.INVALID_TIEBREAKER));
      toastNotifications.addDanger({
        title: errorTitle,
        text: _i18n.i18n.translate('discover.context.invalidTieBreakerFiledSetting', {
          defaultMessage: 'Invalid tie breaker field setting'
        })
      });
      return;
    }
    try {
      setState({
        anchorStatus: {
          value: _context_query_state.LoadingStatus.LOADING
        }
      });
      const sort = (0, _get_es_query_sort.getEsQuerySort)({
        sortDir: _public2.SortDirection.desc,
        timeFieldName: dataView.timeFieldName,
        tieBreakerFieldName,
        isTimeNanosBased: dataView.isTimeNanosBased()
      });
      const result = await (0, _anchor.fetchAnchor)(anchorId, dataView, searchSource, sort, useNewFieldsApi, services);
      setState({
        anchor: result.anchorRow,
        anchorInterceptedWarnings: result.interceptedWarnings,
        anchorStatus: {
          value: _context_query_state.LoadingStatus.LOADED
        }
      });
      return result.anchorRow;
    } catch (error) {
      setState(createError('anchorStatus', _context_query_state.FailureReason.UNKNOWN, error));
      toastNotifications.addDanger({
        title: errorTitle,
        text: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.MarkdownSimple, null, error.message), {
          theme: services.core.theme,
          i18n: services.core.i18n
        })
      });
    }
  }, [services, tieBreakerFieldName, setState, toastNotifications, dataView, anchorId, searchSource, useNewFieldsApi]);
  const fetchSurroundingRows = (0, _react.useCallback)(async (type, fetchedAnchor) => {
    const filters = filterManager.getFilters();
    const count = type === _context.SurrDocType.PREDECESSORS ? appState.predecessorCount : appState.successorCount;
    const anchor = fetchedAnchor || fetchedState.anchor;
    const statusKey = `${type}Status`;
    const warningsKey = `${type}InterceptedWarnings`;
    const errorTitle = _i18n.i18n.translate('discover.context.unableToLoadDocumentDescription', {
      defaultMessage: 'Unable to load documents'
    });
    try {
      setState({
        [statusKey]: {
          value: _context_query_state.LoadingStatus.LOADING
        }
      });
      const result = anchor.id ? await (0, _context.fetchSurroundingDocs)(type, dataView, anchor, tieBreakerFieldName, _public2.SortDirection.desc, count, filters, data, useNewFieldsApi, services) : {
        rows: [],
        interceptedWarnings: undefined
      };
      setState({
        [type]: result.rows,
        [warningsKey]: result.interceptedWarnings,
        [statusKey]: {
          value: _context_query_state.LoadingStatus.LOADED
        }
      });
    } catch (error) {
      setState(createError(statusKey, _context_query_state.FailureReason.UNKNOWN, error));
      toastNotifications.addDanger({
        title: errorTitle,
        text: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.MarkdownSimple, null, error.message), {
          theme: services.core.theme,
          i18n: services.core.i18n
        })
      });
    }
  }, [services, filterManager, appState, fetchedState.anchor, tieBreakerFieldName, setState, dataView, toastNotifications, useNewFieldsApi, data]);
  const fetchContextRows = (0, _react.useCallback)(anchor => Promise.allSettled([fetchSurroundingRows(_context.SurrDocType.PREDECESSORS, anchor), fetchSurroundingRows(_context.SurrDocType.SUCCESSORS, anchor)]), [fetchSurroundingRows]);
  const fetchAllRows = (0, _react.useCallback)(() => {
    fetchAnchorRow().then(anchor => anchor && fetchContextRows(anchor));
  }, [fetchAnchorRow, fetchContextRows]);
  const resetFetchedState = (0, _react.useCallback)(() => {
    setFetchedState((0, _context_query_state.getInitialContextQueryState)());
  }, []);
  return {
    fetchedState,
    fetchAllRows,
    fetchContextRows,
    fetchSurroundingRows,
    resetFetchedState
  };
}