"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamsStats = getDataStreamsStats;
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreamsStats(options) {
  const {
    esClient,
    type,
    datasetQuery
  } = options;
  const matchingDataStreamsStats = await _services.dataStreamService.getMatchingDataStreamsStats(esClient, {
    type: type !== null && type !== void 0 ? type : '*',
    dataset: datasetQuery ? `*${datasetQuery}*` : '*'
  });
  const mappedDataStreams = matchingDataStreamsStats.map(dataStream => {
    return {
      name: dataStream.data_stream,
      size: dataStream.store_size,
      size_bytes: dataStream.store_size_bytes,
      last_activity: dataStream.maximum_timestamp
    };
  });
  return {
    items: mappedDataStreams
  };
}