"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Table = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _translations = require("../../../common/translations");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Table = () => {
  const {
    sort,
    onTableChange,
    pagination,
    renderedItems,
    columns,
    loading,
    resultsCount
  } = (0, _hooks.useDatasetQualityTable)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.tableSummary",
    defaultMessage: "Showing {items} Datasets",
    values: {
      items: resultsCount
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    style: {
      height: 2
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    sorting: sort,
    onChange: onTableChange,
    pagination: pagination,
    "data-test-subj": "datasetQualityTable",
    isSelectable: true,
    rowProps: {
      'data-test-subj': 'datasetQualityTableRow'
    },
    items: renderedItems,
    columns: columns,
    loading: loading,
    noItemsMessage: loading ? _translations.loadingDatasetsText : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "datasetQualityTableNoData",
      layout: "vertical",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.noDatasetsTitle),
      hasBorder: false,
      titleSize: "m"
    })
  }));
};
exports.Table = Table;