"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDatasetQualitTableColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/fleet-plugin/public");
var _fieldTypes = require("@kbn/field-types");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/constants");
var _logging = _interopRequireDefault(require("../../icons/logging.svg"));
var _quality_indicator = require("../quality_indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nameColumnName = _i18n.i18n.translate('xpack.datasetQuality.nameColumnName', {
  defaultMessage: 'Dataset Name'
});
const sizeColumnName = _i18n.i18n.translate('xpack.datasetQuality.sizeColumnName', {
  defaultMessage: 'Size'
});
const malformedDocsColumnName = _i18n.i18n.translate('xpack.datasetQuality.malformedDocsColumnName', {
  defaultMessage: 'Malformed Docs'
});
const malformedDocsDescription = minimimPercentage => _i18n.i18n.translate('xpack.datasetQuality.malformedDocsQualityDescription', {
  defaultMessage: 'greater than {minimimPercentage}%',
  values: {
    minimimPercentage
  }
});
const malformedDocsColumnTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.malformedDocsColumnTooltip",
  defaultMessage: "The percentage of malformed documents -documents with the {ignoredProperty} property- in your dataset. {visualQueue}",
  values: {
    ignoredProperty: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      language: "json",
      transparentBackground: true
    }, "_ignored"),
    visualQueue: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityIndicator, {
      quality: "poor"
    }), ` ${malformedDocsDescription(_constants.POOR_QUALITY_MINIMUM_PERCENTAGE)}`)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityIndicator, {
      quality: "degraded"
    }), ` ${malformedDocsDescription(_constants.DEGRADED_QUALITY_MINIMUM_PERCENTAGE)}`)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityIndicator, {
      quality: "good"
    }), ' 0%')))
  }
});
const lastActivityColumnName = _i18n.i18n.translate('xpack.datasetQuality.lastActivityColumnName', {
  defaultMessage: 'Last Activity'
});
const getDatasetQualitTableColumns = ({
  fieldFormats,
  loadingMalformedStats
}) => {
  return [{
    name: nameColumnName,
    field: 'title',
    sortable: true,
    render: (title, dataStreamStat) => {
      const {
        integration
      } = dataStreamStat;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, integration ? /*#__PURE__*/_react.default.createElement(_public.PackageIcon, {
        packageName: integration.name,
        version: integration.version,
        icons: integration.icons,
        size: "m",
        tryApi: true
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: _logging.default,
        size: "m"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, title));
    }
  }, {
    name: sizeColumnName,
    field: 'size',
    sortable: true
  }, {
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: malformedDocsColumnTooltip
    }, /*#__PURE__*/_react.default.createElement("span", null, `${malformedDocsColumnName} `, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    field: 'malformedDocs',
    sortable: true,
    render: (_, dataStreamStat) => /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      width: "50px",
      height: "20px",
      borderRadius: "m",
      isLoading: loadingMalformedStats,
      contentAriaLabel: "Example description"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityPercentageIndicator, {
      percentage: dataStreamStat.malformedDocs
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, `${dataStreamStat.malformedDocs}%`)))
  }, {
    name: lastActivityColumnName,
    field: 'lastActivity',
    render: timestamp => fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.DATE, [_fieldTypes.ES_FIELD_TYPES.DATE]).convert(timestamp),
    sortable: true
  }];
};
exports.getDatasetQualitTableColumns = getDatasetQualitTableColumns;