"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditFlyout = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _overrides = require("./overrides");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EditFlyout extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "applyAndClose", () => {
      this.applyOverrides();
      this.props.closeEditFlyout();
    });
    (0, _defineProperty2.default)(this, "setApplyOverrides", applyOverrides => {
      this.applyOverrides = applyOverrides;
    });
    (0, _defineProperty2.default)(this, "unsetApplyOverrides", () => {
      this.applyOverrides = () => {};
    });
    (0, _defineProperty2.default)(this, "setOverridesValid", overridesValid => {
      this.setState({
        overridesValid
      });
    });
    this.applyOverrides = () => {};
    this.state = {
      overridesValid: true
    };
  }
  render() {
    const {
      isFlyoutVisible,
      closeEditFlyout,
      setOverrides,
      overrides,
      originalSettings,
      fields
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFlyoutVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout
    // ownFocus
    , {
      onClose: closeEditFlyout,
      size: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.editFlyout.overrideSettingsTitle",
      defaultMessage: "Override settings"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_overrides.Overrides, {
      setOverrides: setOverrides,
      overrides: overrides,
      originalSettings: originalSettings,
      setApplyOverrides: this.setApplyOverrides,
      setOverridesValid: this.setOverridesValid,
      fields: fields
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      onClick: closeEditFlyout,
      flush: "left"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.editFlyout.closeOverrideSettingsButtonLabel",
      defaultMessage: "Close"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.applyAndClose,
      isDisabled: this.state.overridesValid === false,
      fill: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.editFlyout.applyOverrideSettingsButtonLabel",
      defaultMessage: "Apply"
    })))))));
  }
}
exports.EditFlyout = EditFlyout;