"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BooleanContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _i18nReact = require("@kbn/i18n-react");
var _mlNumberUtils = require("@kbn/ml-number-utils");
var _i18n = require("@kbn/i18n");
var _top_values = require("../../../top_values");
var _expanded_row_field_header = require("../expanded_row_field_header");
var _utils = require("../../utils");
var _hooks = require("../../hooks");
var _document_stats = require("./document_stats");
var _expanded_row_content = require("./expanded_row_content");
var _expanded_row_panel = require("./expanded_row_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getPercentLabel(value) {
  if (value === 0) {
    return '0%';
  }
  if (value >= 0.1) {
    return `${(0, _mlNumberUtils.roundToDecimalPlace)(value)}%`;
  } else {
    return '< 0.1%';
  }
}
function getFormattedValue(value, totalCount) {
  const percentage = value / totalCount * 100;
  return `${value} (${getPercentLabel(percentage)})`;
}
const BOOLEAN_DISTRIBUTION_CHART_HEIGHT = 70;
const BooleanContent = ({
  config,
  onAddFilter
}) => {
  const fieldFormat = 'fieldFormat' in config ? config.fieldFormat : undefined;
  const formattedPercentages = (0, _react.useMemo)(() => (0, _utils.getTFPercentage)(config), [config]);
  const theme = (0, _hooks.useDataVizChartTheme)();
  if (!formattedPercentages) return null;
  const {
    count
  } = formattedPercentages;
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerBooleanContent'
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config
  }), /*#__PURE__*/_react.default.createElement(_top_values.TopValues, {
    stats: config.stats,
    fieldFormat: fieldFormat,
    barColor: "success",
    onAddFilter: onAddFilter
  }), /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    className: 'dvPanel__wrapper dvPanel--uniform'
  }, /*#__PURE__*/_react.default.createElement(_expanded_row_field_header.ExpandedRowFieldHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.field.cardBoolean.valuesLabel",
    defaultMessage: "Values"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    renderer: "canvas",
    size: {
      height: BOOLEAN_DISTRIBUTION_CHART_HEIGHT
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: "bottom",
    showOverlappingTicks: true
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left2",
    title: "Left axis",
    hide: true,
    tickFormat: d => getFormattedValue(d, count)
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    theme: theme,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: config.fieldName || fieldFormat,
    data: [{
      x: 'true',
      count: formattedPercentages.trueCount
    }, {
      x: 'false',
      count: formattedPercentages.falseCount
    }],
    splitSeriesAccessors: ['x'],
    stackAccessors: ['x'],
    xAccessor: "x",
    xScaleType: _charts.ScaleType.Ordinal,
    yAccessors: ['count'],
    yScaleType: _charts.ScaleType.Linear
  }))));
};
exports.BooleanContent = BooleanContent;