"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExamplesList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _expanded_row_field_header = require("../stats_table/components/expanded_row_field_header");
var _expanded_row_panel = require("../stats_table/components/field_data_expanded_row/expanded_row_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_EXAMPLE = _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.field.examplesList.emptyExampleMessage', {
  defaultMessage: '(empty)'
});
const ExamplesList = ({
  examples
}) => {
  if (examples === undefined || examples === null || !Array.isArray(examples)) {
    return null;
  }
  let examplesContent;
  if (examples.length === 0) {
    examplesContent = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.field.examplesList.noExamplesMessage",
      defaultMessage: "No examples were obtained for this field"
    });
  } else {
    examplesContent = examples.map((example, i) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
        size: "xs",
        key: `example_${i}`,
        label: typeof example === 'string' ? example === '' ? EMPTY_EXAMPLE : example : JSON.stringify(example)
      });
    });
  }
  return /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    dataTestSubj: "dataVisualizerFieldDataExamplesList",
    className: "dvText__wrapper dvPanel__wrapper"
  }, /*#__PURE__*/_react.default.createElement(_expanded_row_field_header.ExpandedRowFieldHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.field.examplesList.title",
    defaultMessage: "{numExamples, plural, one {Value} other {Examples}}",
    values: {
      numExamples: examples.length
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    showToolTips: true,
    maxWidth: 's',
    gutterSize: 'none',
    flush: true
  }, examplesContent));
};
exports.ExamplesList = ExamplesList;