"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rateLimitingForkJoin = rateLimitingForkJoin;
exports.removeFieldAttrs = void 0;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const removeFieldAttrs = runtimeField => {
  const {
    type,
    script,
    fields
  } = runtimeField;
  const fieldsTypeOnly = fields && {
    fields: Object.entries(fields).reduce((col, [fieldName, field]) => {
      col[fieldName] = {
        type: field.type
      };
      return col;
    }, {})
  };
  return {
    type,
    script,
    ...fieldsTypeOnly
  };
};
exports.removeFieldAttrs = removeFieldAttrs;
const MAX_CONCURRENT_REQUESTS = 3;
/**
 * Helper function to run forkJoin
 * with restrictions on how many input observables can be subscribed to concurrently
 */
function rateLimitingForkJoin(observables, maxConcurrentRequests = MAX_CONCURRENT_REQUESTS, failValue) {
  return (0, _rxjs.from)(observables).pipe((0, _operators.mergeMap)((observable, index) => observable.pipe((0, _operators.last)(), (0, _operators.map)(value => ({
    index,
    value
  })), (0, _rxjs.catchError)(() => (0, _rxjs.of)({
    index,
    value: failValue
  }))), maxConcurrentRequests), (0, _operators.toArray)(), (0, _operators.map)(indexedObservables => indexedObservables.sort((l, r) => l.index - r.index).map(obs => obs.value)));
}