"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceFiltersTable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reselect = require("reselect");
var _eui = require("@elastic/eui");
var _components = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SourceFiltersTable extends _react.Component {
  // Source filters do not have unique ids, only the value is stored.
  // To ensure we can create a consistent and expected UX when managing
  // source filters, we are assigning a unique id to each filter on the
  // client side only

  constructor(_props) {
    super(_props);
    (0, _defineProperty2.default)(this, "clientSideId", 0);
    (0, _defineProperty2.default)(this, "updateFilters", () => {
      const sourceFilters = this.props.indexPattern.sourceFilters;
      const filters = (sourceFilters || []).map(sourceFilter => ({
        ...sourceFilter,
        clientId: ++this.clientSideId
      }));
      this.setState({
        filters
      });
    });
    (0, _defineProperty2.default)(this, "getFilteredFilters", (0, _reselect.createSelector)(state => state.filters, (_state, props) => props.filterFilter, (filters, filterFilter) => {
      if (filterFilter) {
        const filterFilterToLowercase = filterFilter.toLowerCase();
        return filters.filter(filter => filter.value.toLowerCase().includes(filterFilterToLowercase));
      }
      return filters;
    }));
    (0, _defineProperty2.default)(this, "startDeleteFilter", filter => {
      this.setState({
        filterToDelete: filter,
        isDeleteConfirmationModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "hideDeleteConfirmationModal", () => {
      this.setState({
        filterToDelete: undefined,
        isDeleteConfirmationModalVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "deleteFilter", async () => {
      const {
        indexPattern,
        onAddOrRemoveFilter,
        saveIndexPattern
      } = this.props;
      const {
        filterToDelete,
        filters
      } = this.state;
      indexPattern.sourceFilters = filters.filter(filter => {
        return filter.clientId !== (filterToDelete === null || filterToDelete === void 0 ? void 0 : filterToDelete.clientId);
      });
      this.setState({
        isSaving: true
      });
      await saveIndexPattern(indexPattern);
      if (onAddOrRemoveFilter) {
        onAddOrRemoveFilter();
      }
      this.updateFilters();
      this.setState({
        isSaving: false
      });
      this.hideDeleteConfirmationModal();
    });
    (0, _defineProperty2.default)(this, "onAddFilter", async value => {
      const {
        indexPattern,
        onAddOrRemoveFilter,
        saveIndexPattern
      } = this.props;
      indexPattern.sourceFilters = [...(indexPattern.sourceFilters || []), {
        value
      }];
      this.setState({
        isSaving: true
      });
      await saveIndexPattern(indexPattern);
      if (onAddOrRemoveFilter) {
        onAddOrRemoveFilter();
      }
      this.updateFilters();
      this.setState({
        isSaving: false
      });
    });
    (0, _defineProperty2.default)(this, "saveFilter", async ({
      clientId,
      value
    }) => {
      const {
        indexPattern,
        saveIndexPattern
      } = this.props;
      const {
        filters
      } = this.state;
      indexPattern.sourceFilters = filters.map(filter => {
        if (filter.clientId === clientId) {
          return {
            value,
            clientId
          };
        }
        return filter;
      });
      this.setState({
        isSaving: true
      });
      await saveIndexPattern(indexPattern);
      this.updateFilters();
      this.setState({
        isSaving: false
      });
    });
    this.state = {
      filterToDelete: undefined,
      isDeleteConfirmationModalVisible: false,
      isSaving: false,
      filters: []
    };
  }
  UNSAFE_componentWillMount() {
    this.updateFilters();
  }
  render() {
    const {
      indexPattern,
      fieldWildcardMatcher
    } = this.props;
    const {
      isSaving,
      filterToDelete
    } = this.state;
    const filteredFilters = this.getFilteredFilters(this.state, this.props);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.Header, null), /*#__PURE__*/_react.default.createElement(_components.AddFilter, {
      onAddFilter: this.onAddFilter
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_components.Table, {
      isSaving: isSaving,
      indexPattern: indexPattern,
      items: filteredFilters,
      fieldWildcardMatcher: fieldWildcardMatcher,
      deleteFilter: this.startDeleteFilter,
      saveFilter: this.saveFilter
    }), filterToDelete && /*#__PURE__*/_react.default.createElement(_components.DeleteFilterConfirmationModal, {
      filterToDeleteValue: filterToDelete.value,
      onCancelConfirmationModal: this.hideDeleteConfirmationModal,
      onDeleteFilter: this.deleteFilter
    }));
  }
}
exports.SourceFiltersTable = SourceFiltersTable;