"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.singleAstriskValidator = exports.schema = void 0;
var _public = require("@kbn/data-views-plugin/public");
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const singleAstriskValidator = (...args) => {
  const [{
    value,
    path
  }] = args;
  const message = _i18n.i18n.translate('indexPatternEditor.validations.noSingleAstriskPattern', {
    defaultMessage: "A single '*' is not an allowed index pattern"
  });
  return value === '*' ? {
    code: 'ERR_FIELD_MISSING',
    path,
    message
  } : undefined;
};
exports.singleAstriskValidator = singleAstriskValidator;
const schema = {
  title: {
    label: _i18n.i18n.translate('indexPatternEditor.editor.form.titleLabel', {
      defaultMessage: 'Index pattern'
    }),
    defaultValue: '',
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('indexPatternEditor.validations.titleIsRequiredErrorMessage', {
        defaultMessage: 'An index pattern is required.'
      }))
    }, {
      validator: singleAstriskValidator
    }]
  },
  name: {
    label: _i18n.i18n.translate('indexPatternEditor.editor.form.nameLabel', {
      defaultMessage: 'Name'
    }),
    defaultValue: '',
    validations: []
  },
  timestampField: {
    label: _i18n.i18n.translate('indexPatternEditor.editor.form.timeFieldLabel', {
      defaultMessage: 'Timestamp field'
    }),
    helpText: _i18n.i18n.translate('indexPatternEditor.editor.form.timestampFieldHelp', {
      defaultMessage: 'Select a timestamp field for use with the global time filter.'
    }),
    validations: []
  },
  allowHidden: {
    label: _i18n.i18n.translate('indexPatternEditor.editor.form.allowHiddenLabel', {
      defaultMessage: 'Allow hidden and system indices'
    }),
    defaultValue: false
  },
  id: {
    label: _i18n.i18n.translate('indexPatternEditor.editor.form.customIdLabel', {
      defaultMessage: 'Custom data view ID'
    }),
    helpText: _i18n.i18n.translate('indexPatternEditor.editor.form.customIdHelp', {
      defaultMessage: 'Kibana provides a unique identifier for each data view, or you can create your own.'
    })
  },
  type: {
    label: _i18n.i18n.translate('indexPatternEditor.editor.form.TypeLabel', {
      defaultMessage: 'Data view type'
    }),
    defaultValue: _public.INDEX_PATTERN_TYPE.DEFAULT
  },
  isAdHoc: {
    label: _i18n.i18n.translate('indexPatternEditor.editor.form.IsAdHocLabel', {
      defaultMessage: 'Create AdHoc DataView'
    }),
    defaultValue: false,
    type: 'hidden'
  }
};
exports.schema = schema;