"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TitleDocsPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TitleDocsPopover = () => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const helpButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => setIsOpen(prev => !prev),
    iconType: "documentation",
    "data-test-subj": "indexPatternDocsButton",
    "aria-label": _i18n.i18n.translate('indexPatternEditor.titleDocsPopover.ariaLabel', {
      defaultMessage: 'Index pattern examples'
    })
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: helpButton,
    isOpen: isOpen,
    display: "inlineBlock",
    panelPaddingSize: "none",
    anchorPosition: "upRight",
    closePopover: () => setIsOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, _i18n.i18n.translate('indexPatternEditor.titleDocsPopover.title', {
    defaultMessage: 'Index pattern'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "eui-yScroll",
    css: (0, _react2.css)`
          max-height: 50vh;
          max-width: 500px;
        `,
    color: "transparent",
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "indexPatternDocsPopoverContent"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternEditor.titleDocsPopover.indexPatternDescription",
    defaultMessage: "An index pattern is a string that you use to match one or more data streams, indices, or aliases."
  })), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternEditor.titleDocsPopover.useWildcardDescription",
    defaultMessage: "Match multiple sources with a wildcard (*)."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "filebeat-*"))), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternEditor.titleDocsPopover.useCommasDescription",
    defaultMessage: "Separate multiple single sources with a comma (,)."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "filebeat-a,filebeat-b"))), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternEditor.titleDocsPopover.useMinusDescription",
    defaultMessage: "Exclude a source by preceding it with a minus sign (-)."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "filebeat-*,-filebeat-c"))), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternEditor.titleDocsPopover.useCrossClusterSearchDescription",
    defaultMessage: "For cross-cluster search, precede with the cluster name followed by a colon (:)."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "cluster1:filebeat-*")), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "cluster1:filebeat-*,cluster2:filebeat-*")), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "cluster*:filebeat-*,filebeat-*"))), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('indexPatternEditor.titleDocsPopover.dontUseSpecialCharactersDescription', {
    defaultMessage: 'Spaces and the characters /?"<>| are not allowed.'
  })))))));
};
exports.TitleDocsPopover = TitleDocsPopover;