"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRenameActionDescriptor = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const RenameDialog = ({
  onActionDismiss,
  ...props
}) => {
  const {
    api,
    searchSession
  } = props;
  const {
    id,
    name: originalName
  } = searchSession;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [newName, setNewName] = (0, _react.useState)(originalName);
  const title = _i18n.i18n.translate('data.mgmt.searchSessions.renameModal.title', {
    defaultMessage: 'Edit search session name'
  });
  const confirm = _i18n.i18n.translate('data.mgmt.searchSessions.renameModal.renameButton', {
    defaultMessage: 'Save'
  });
  const cancel = _i18n.i18n.translate('data.mgmt.searchSessions.renameModal.cancelButton', {
    defaultMessage: 'Cancel'
  });
  const label = _i18n.i18n.translate('data.mgmt.searchSessions.renameModal.searchSessionNameInputLabel', {
    defaultMessage: 'Search session name'
  });
  const isNewNameValid = newName && originalName !== newName;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onActionDismiss,
    initialFocus: "[name=newName]"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "newName",
    placeholder: originalName,
    value: newName,
    onChange: e => setNewName(e.target.value)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onActionDismiss,
    "data-test-subj": "cancelEditName"
  }, cancel), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !isNewNameValid,
    onClick: async () => {
      if (!isNewNameValid) return;
      setIsLoading(true);
      await api.sendRename(id, newName);
      setIsLoading(false);
      onActionDismiss();
    },
    fill: true,
    isLoading: isLoading
  }, confirm)));
};
const createRenameActionDescriptor = (api, uiSession, core) => ({
  iconType: 'pencil',
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "data.mgmt.searchSessions.actionRename",
    defaultMessage: "Edit name"
  }),
  onClick: async () => {
    const ref = core.overlays.openModal((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(RenameDialog, {
      onActionDismiss: () => ref === null || ref === void 0 ? void 0 : ref.close(),
      api: api,
      searchSession: uiSession
    }), {
      theme$: core.theme.theme$
    }));
    await ref.onClose;
  }
});
exports.createRenameActionDescriptor = createRenameActionDescriptor;