"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRootCause = getRootCause;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getFailedShardCause(error) {
  var _error$caused_by, _failedShards$;
  const failedShards = error.failed_shards || ((_error$caused_by = error.caused_by) === null || _error$caused_by === void 0 ? void 0 : _error$caused_by.failed_shards);
  return failedShards ? (_failedShards$ = failedShards[0]) === null || _failedShards$ === void 0 ? void 0 : _failedShards$.reason : undefined;
}
function getNestedCause(error) {
  return error.caused_by ? getNestedCause(error.caused_by) : error;
}
function getRootCause(error) {
  return error ?
  // Give shard failures priority, then try to get the error navigating nested objects
  getFailedShardCause(error) || getNestedCause(error) : undefined;
}