"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "APPLY_FILTER_TRIGGER", {
  enumerable: true,
  get: function () {
    return _triggers.APPLY_FILTER_TRIGGER;
  }
});
Object.defineProperty(exports, "AggGroupLabels", {
  enumerable: true,
  get: function () {
    return _common.AggGroupLabels;
  }
});
Object.defineProperty(exports, "AggGroupNames", {
  enumerable: true,
  get: function () {
    return _common.AggGroupNames;
  }
});
Object.defineProperty(exports, "BUCKET_TYPES", {
  enumerable: true,
  get: function () {
    return _common.BUCKET_TYPES;
  }
});
Object.defineProperty(exports, "DuplicateDataViewError", {
  enumerable: true,
  get: function () {
    return _common.DuplicateDataViewError;
  }
});
Object.defineProperty(exports, "ES_FIELD_TYPES", {
  enumerable: true,
  get: function () {
    return _common.ES_FIELD_TYPES;
  }
});
Object.defineProperty(exports, "FilterManager", {
  enumerable: true,
  get: function () {
    return _query.FilterManager;
  }
});
Object.defineProperty(exports, "KBN_FIELD_TYPES", {
  enumerable: true,
  get: function () {
    return _common.KBN_FIELD_TYPES;
  }
});
Object.defineProperty(exports, "METRIC_TYPES", {
  enumerable: true,
  get: function () {
    return _common.METRIC_TYPES;
  }
});
Object.defineProperty(exports, "NowProvider", {
  enumerable: true,
  get: function () {
    return _now_provider.NowProvider;
  }
});
Object.defineProperty(exports, "QueryService", {
  enumerable: true,
  get: function () {
    return _query.QueryService;
  }
});
Object.defineProperty(exports, "SEARCH_SESSIONS_MANAGEMENT_ID", {
  enumerable: true,
  get: function () {
    return _search.SEARCH_SESSIONS_MANAGEMENT_ID;
  }
});
Object.defineProperty(exports, "SearchSessionState", {
  enumerable: true,
  get: function () {
    return _search.SearchSessionState;
  }
});
Object.defineProperty(exports, "SearchSource", {
  enumerable: true,
  get: function () {
    return _search.SearchSource;
  }
});
Object.defineProperty(exports, "SortDirection", {
  enumerable: true,
  get: function () {
    return _search.SortDirection;
  }
});
Object.defineProperty(exports, "TimeHistory", {
  enumerable: true,
  get: function () {
    return _query.TimeHistory;
  }
});
Object.defineProperty(exports, "UI_SETTINGS", {
  enumerable: true,
  get: function () {
    return _common.UI_SETTINGS;
  }
});
Object.defineProperty(exports, "calculateBounds", {
  enumerable: true,
  get: function () {
    return _common.calculateBounds;
  }
});
Object.defineProperty(exports, "connectToQueryState", {
  enumerable: true,
  get: function () {
    return _query.connectToQueryState;
  }
});
Object.defineProperty(exports, "createSavedQueryService", {
  enumerable: true,
  get: function () {
    return _query.createSavedQueryService;
  }
});
exports.exporters = void 0;
Object.defineProperty(exports, "extractSearchSourceReferences", {
  enumerable: true,
  get: function () {
    return _search.extractSearchSourceReferences;
  }
});
Object.defineProperty(exports, "fieldList", {
  enumerable: true,
  get: function () {
    return _common.fieldList;
  }
});
Object.defineProperty(exports, "flattenHit", {
  enumerable: true,
  get: function () {
    return _common.flattenHit;
  }
});
Object.defineProperty(exports, "generateFilters", {
  enumerable: true,
  get: function () {
    return _query.generateFilters;
  }
});
Object.defineProperty(exports, "getDefaultQuery", {
  enumerable: true,
  get: function () {
    return _query.getDefaultQuery;
  }
});
Object.defineProperty(exports, "getDisplayValueFromFilter", {
  enumerable: true,
  get: function () {
    return _query.getDisplayValueFromFilter;
  }
});
Object.defineProperty(exports, "getEsQueryConfig", {
  enumerable: true,
  get: function () {
    return _common.getEsQueryConfig;
  }
});
Object.defineProperty(exports, "getFieldDisplayValueFromFilter", {
  enumerable: true,
  get: function () {
    return _query.getFieldDisplayValueFromFilter;
  }
});
Object.defineProperty(exports, "getIndexPatternFromFilter", {
  enumerable: true,
  get: function () {
    return _query.getIndexPatternFromFilter;
  }
});
Object.defineProperty(exports, "getQueryLog", {
  enumerable: true,
  get: function () {
    return _query.getQueryLog;
  }
});
Object.defineProperty(exports, "getSearchErrorOverrideDisplay", {
  enumerable: true,
  get: function () {
    return _search.getSearchErrorOverrideDisplay;
  }
});
Object.defineProperty(exports, "getSearchParamsFromRequest", {
  enumerable: true,
  get: function () {
    return _search.getSearchParamsFromRequest;
  }
});
Object.defineProperty(exports, "getTime", {
  enumerable: true,
  get: function () {
    return _common.getTime;
  }
});
exports.indexPatterns = void 0;
Object.defineProperty(exports, "injectSearchSourceReferences", {
  enumerable: true,
  get: function () {
    return _search.injectSearchSourceReferences;
  }
});
Object.defineProperty(exports, "isEsError", {
  enumerable: true,
  get: function () {
    return _search.isEsError;
  }
});
Object.defineProperty(exports, "isQuery", {
  enumerable: true,
  get: function () {
    return _common.isQuery;
  }
});
Object.defineProperty(exports, "isRunningResponse", {
  enumerable: true,
  get: function () {
    return _common.isRunningResponse;
  }
});
Object.defineProperty(exports, "isTimeRange", {
  enumerable: true,
  get: function () {
    return _common.isTimeRange;
  }
});
Object.defineProperty(exports, "mapAndFlattenFilters", {
  enumerable: true,
  get: function () {
    return _query.mapAndFlattenFilters;
  }
});
Object.defineProperty(exports, "noSearchSessionStorageCapabilityMessage", {
  enumerable: true,
  get: function () {
    return _search.noSearchSessionStorageCapabilityMessage;
  }
});
Object.defineProperty(exports, "parseSearchSourceJSON", {
  enumerable: true,
  get: function () {
    return _search.parseSearchSourceJSON;
  }
});
exports.plugin = plugin;
exports.search = void 0;
Object.defineProperty(exports, "syncGlobalQueryStateWithUrl", {
  enumerable: true,
  get: function () {
    return _query.syncGlobalQueryStateWithUrl;
  }
});
Object.defineProperty(exports, "syncQueryStateWithUrl", {
  enumerable: true,
  get: function () {
    return _query.syncQueryStateWithUrl;
  }
});
Object.defineProperty(exports, "tabifyAggResponse", {
  enumerable: true,
  get: function () {
    return _common.tabifyAggResponse;
  }
});
Object.defineProperty(exports, "waitUntilNextSessionCompletes$", {
  enumerable: true,
  get: function () {
    return _search.waitUntilNextSessionCompletes$;
  }
});
var _common = require("../common");
var _query = require("./query");
var _data_views = require("./data_views");
var _search = require("./search");
var _now_provider = require("./now_provider");
var _triggers = require("./triggers");
var _plugin = require("./plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * Filters:
 */

/**
 * Exporters (CSV)
 */

const exporters = {
  datatableToCSV: _common.datatableToCSV,
  CSV_MIME_TYPE: _common.CSV_MIME_TYPE,
  cellHasFormulas: _common.cellHasFormulas,
  tableHasFormulas: _common.tableHasFormulas
};

/*
 * Index patterns:
 */
exports.exporters = exporters;
// Index patterns namespace:
const indexPatterns = {
  ILLEGAL_CHARACTERS_KEY: _data_views.ILLEGAL_CHARACTERS_KEY,
  CONTAINS_SPACES_KEY: _data_views.CONTAINS_SPACES_KEY,
  ILLEGAL_CHARACTERS_VISIBLE: _data_views.ILLEGAL_CHARACTERS_VISIBLE,
  ILLEGAL_CHARACTERS: _data_views.ILLEGAL_CHARACTERS,
  isFilterable: _common.isFilterable,
  isNestedField: _common.isNestedField,
  isMultiField: _common.isMultiField,
  getFieldSubtypeMulti: _common.getFieldSubtypeMulti,
  getFieldSubtypeNested: _common.getFieldSubtypeNested,
  validate: _data_views.validateDataView
};

/*
 * Search:
 */
exports.indexPatterns = indexPatterns;
// Search namespace
const search = {
  aggs: {
    CidrMask: _common.CidrMask,
    dateHistogramInterval: _common.dateHistogramInterval,
    intervalOptions: _common.intervalOptions,
    InvalidEsCalendarIntervalError: _common.InvalidEsCalendarIntervalError,
    InvalidEsIntervalFormatError: _common.InvalidEsIntervalFormatError,
    IpAddress: _common.IpAddress,
    isDateHistogramBucketAggConfig: _common.isDateHistogramBucketAggConfig,
    // TODO: remove in build_pipeline refactor
    isNumberType: _common.isNumberType,
    isStringType: _common.isStringType,
    isType: _common.isType,
    isValidEsInterval: _common.isValidEsInterval,
    isValidInterval: _common.isValidInterval,
    parentPipelineType: _common.parentPipelineType,
    parseEsInterval: _common.parseEsInterval,
    parseInterval: _common.parseInterval,
    propFilter: _common.propFilter,
    siblingPipelineType: _common.siblingPipelineType,
    termsAggFilter: _common.termsAggFilter,
    toAbsoluteDates: _common.toAbsoluteDates,
    boundsDescendingRaw: _common.boundsDescendingRaw,
    calcAutoIntervalLessThan: _common.calcAutoIntervalLessThan
  },
  getResponseInspectorStats: _common.getResponseInspectorStats,
  tabifyAggResponse: _common.tabifyAggResponse,
  tabifyGetColumns: _common.tabifyGetColumns
};

/*
 * UI components
 */

/**
 * Types to be shared externally
 * @public
 */

/*
 * Plugin setup
 */
exports.search = search;
function plugin(initializerContext) {
  return new _plugin.DataPublicPlugin(initializerContext);
}

// Export plugin after all other imports