"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTopHitFilter = exports.createMetricFilter = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createMetricFilter = (aggConfig, key) => {
  const indexPattern = aggConfig.getIndexPattern();
  if (aggConfig.getField()) {
    return (0, _esQuery.buildExistsFilter)(aggConfig.getField(), indexPattern);
  }
};
exports.createMetricFilter = createMetricFilter;
const createTopHitFilter = (aggConfig, key) => {
  const indexPattern = aggConfig.getIndexPattern();
  const field = aggConfig.getField();
  if (!field) {
    return;
  }
  return Array.isArray(key) ? (0, _esQuery.buildCombinedFilter)(_esQuery.BooleanRelation.OR, key.map(k => (0, _esQuery.buildPhraseFilter)(field, k, indexPattern)), indexPattern) : (0, _esQuery.buildPhraseFilter)(field, key, indexPattern);
};
exports.createTopHitFilter = createTopHitFilter;