"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startSyncingDashboardDataViews = startSyncingDashboardDataViews;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _public = require("@kbn/embeddable-plugin/public");
var _plugin_services = require("../../../../services/plugin_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function startSyncingDashboardDataViews() {
  const {
    data: {
      dataViews
    }
  } = _plugin_services.pluginServices.getServices();
  const onUpdateDataViews = async newDataViewIds => {
    if (this.controlGroup) this.controlGroup.setRelevantDataViewId(newDataViewIds[0]);

    // fetch all data views. These should be cached locally at this time so we will not need to query ES.
    const responses = await Promise.allSettled(newDataViewIds.map(id => dataViews.get(id)));
    // Keep only fullfilled ones as each panel will handle the rejected ones already on their own
    const allDataViews = responses.filter(response => response.status === 'fulfilled').map(({
      value
    }) => value);
    this.setAllDataViews(allDataViews);
  };
  const updateDataViewsOperator = (0, _rxjs.pipe)((0, _operators.filter)(container => !!container && !(0, _public.isErrorEmbeddable)(container)), (0, _operators.map)(container => {
    const panelDataViewIds = new Set();
    Object.values(container.getChildIds()).forEach(id => {
      const embeddableInstance = container.getChild(id);
      if ((0, _public.isErrorEmbeddable)(embeddableInstance)) return;

      /**
       * TODO - this assumes that all embeddables which communicate data views do so via an `indexPatterns` key on their output.
       * This should be replaced with a more generic, interface based method where an embeddable can communicate a data view ID.
       */
      const childPanelDataViews = embeddableInstance.getOutput().indexPatterns;
      if (!childPanelDataViews) return;
      childPanelDataViews.forEach(dataView => {
        if (dataView.id) panelDataViewIds.add(dataView.id);
      });
    });
    if (container.controlGroup) {
      const controlGroupDataViewIds = container.controlGroup.getOutput().dataViewIds;
      controlGroupDataViewIds === null || controlGroupDataViewIds === void 0 ? void 0 : controlGroupDataViewIds.forEach(dataViewId => panelDataViewIds.add(dataViewId));
    }

    /**
     * If no index patterns have been returned yet, and there is at least one embeddable which
     * hasn't yet loaded, defer the loading of the default index pattern by returning undefined.
     */
    if (panelDataViewIds.size === 0 && Object.keys(container.getOutput().embeddableLoaded).length > 0 && Object.values(container.getOutput().embeddableLoaded).some(value => value === false)) {
      return;
    }
    return Array.from(panelDataViewIds);
  }), (0, _operators.distinctUntilChanged)((a, b) => (0, _fastDeepEqual.default)(a, b)),
  // using switchMap for previous task cancellation
  (0, _operators.switchMap)(allDataViewIds => {
    return new _rxjs.Observable(observer => {
      if (!allDataViewIds) return;
      if (allDataViewIds.length > 0) {
        if (observer.closed) return;
        onUpdateDataViews(allDataViewIds);
        observer.complete();
      } else {
        dataViews.getDefaultId().then(defaultDataViewId => {
          if (observer.closed) return;
          if (defaultDataViewId) {
            onUpdateDataViews([defaultDataViewId]);
          }
          observer.complete();
        });
      }
    });
  }));
  const dataViewSources = [this.getOutput$()];
  if (this.controlGroup) dataViewSources.push(this.controlGroup.getOutput$());
  return (0, _rxjs.combineLatest)(dataViewSources).pipe((0, _operators.map)(() => this), updateDataViewsOperator).subscribe();
}