"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LibraryNotificationPopover = LibraryNotificationPopover;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function LibraryNotificationPopover({
  unlinkAction,
  displayName,
  context,
  icon,
  id
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    embeddable
  } = context;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "text",
      iconType: icon,
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      "data-test-subj": `embeddablePanelNotification-${id}`,
      "aria-label": _dashboard_actions_strings.dashboardLibraryNotificationStrings.getPopoverAriaLabel()
    }),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    anchorPosition: "upCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, displayName), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '300px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _dashboard_actions_strings.dashboardLibraryNotificationStrings.getTooltip()))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": 'libraryNotificationUnlinkButton',
    size: "s",
    fill: true,
    onClick: () => unlinkAction.execute({
      embeddable
    })
  }, unlinkAction.getDisplayName({
    embeddable
  }))))));
}