"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomIntegrationsPlugin = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("../common");
var _services = require("./services");
var _kibana = require("./services/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class CustomIntegrationsPlugin {
  setup(core) {
    // Return methods that should be available to other plugins
    return {
      async getReplacementCustomIntegrations() {
        return core.http.get(_common.ROUTES_REPLACEMENT_CUSTOM_INTEGRATIONS);
      },
      async getAppendCustomIntegrations() {
        return core.http.get(_common.ROUTES_APPEND_CUSTOM_INTEGRATIONS);
      }
    };
  }
  start(coreStart, startPlugins) {
    const services = (0, _kibana.servicesFactory)({
      coreStart,
      startPlugins
    });
    const languageClientsUiComponents = {
      sample: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).SampleClientReadme
      })),
      javascript: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchJsClientReadme
      })),
      python: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchPyClientReadme
      })),
      go: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchGoClientReadme
      })),
      ruby: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchRubyClientReadme
      })),
      java: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchJavaClientReadme
      })),
      php: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchPhpClientReadme
      })),
      dotnet: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchDotnetClientReadme
      }))
    };
    const ContextProvider = ({
      children
    }) => /*#__PURE__*/_react.default.createElement(_services.CustomIntegrationsServicesProvider, services, children);
    return {
      ContextProvider,
      languageClientsUiComponents
    };
  }
  stop() {}
}
exports.CustomIntegrationsPlugin = CustomIntegrationsPlugin;