"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.outdatedDocumentsSearchRead = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _helpers = require("../../../model/helpers");
var _progress = require("../../../model/progress");
var _extract_errors = require("../../../model/extract_errors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const outdatedDocumentsSearchRead = (state, res, context) => {
  if (Either.isLeft(res)) {
    (0, _helpers.throwBadResponse)(state, res);
  }
  let logs = state.logs;
  if (res.right.outdatedDocuments.length > 0) {
    // search returned outdated documents, so we process them
    const progress = (0, _progress.setProgressTotal)(state.progress, res.right.totalHits);
    return {
      ...state,
      controlState: 'OUTDATED_DOCUMENTS_SEARCH_TRANSFORM',
      outdatedDocuments: res.right.outdatedDocuments,
      lastHitSortValue: res.right.lastHitSortValue,
      logs: (0, _progress.logProgress)(state.logs, progress),
      progress
    };
  } else {
    // no more outdated documents , we need to move on
    if (state.corruptDocumentIds.length > 0 || state.transformErrors.length > 0) {
      if (!context.discardCorruptObjects) {
        const transformFailureReason = (0, _extract_errors.extractTransformFailuresReason)(context.migrationDocLinks.resolveMigrationFailures, state.corruptDocumentIds, state.transformErrors);
        return {
          ...state,
          controlState: 'FATAL',
          reason: transformFailureReason
        };
      }

      // at this point, users have configured kibana to discard corrupt objects
      // thus, we can ignore corrupt documents and transform errors and proceed with the migration
      logs = [...state.logs, {
        level: 'warning',
        message: (0, _extract_errors.extractDiscardedCorruptDocs)(state.corruptDocumentIds, state.transformErrors)
      }];
    }

    // If there are no more results we have transformed all outdated
    // documents and we didn't encounter any corrupt documents or transformation errors
    // and can proceed to the next step
    return {
      ...state,
      logs,
      controlState: 'OUTDATED_DOCUMENTS_SEARCH_CLOSE_PIT'
    };
  }
};
exports.outdatedDocumentsSearchRead = outdatedDocumentsSearchRead;