"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregateMappingAdditions = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Merge the added mappings from the given list of model changes.
 * Note: only changes of the `mappings_addition` type have mapping addition.
 */
const aggregateMappingAdditions = changes => {
  let mappings = {};
  changes.forEach(change => {
    if (change.type === 'mappings_addition') {
      mappings = (0, _lodash.merge)(mappings, change.addedMappings);
    }
  });
  return mappings;
};
exports.aggregateMappingAdditions = aggregateMappingAdditions;