"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = exports.PluginsConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _configSchema = require("@kbn/config-schema");
var _lodash = require("lodash");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const configSchema = _configSchema.schema.object({
  initialize: _configSchema.schema.boolean({
    defaultValue: true
  }),
  /**
   * Defines an array of directories where another plugin should be loaded from.
   */
  paths: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: []
  }),
  /**
   * Internal config, not intended to be used by end users. Only for specific
   * internal purposes.
   */
  forceEnableAllPlugins: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: false
  }))
});
const config = {
  path: 'plugins',
  schema: configSchema
};

/** @internal */
exports.config = config;
class PluginsConfig {
  /**
   * Indicates whether or not plugins should be initialized.
   */

  /**
   * Defines directories that we should scan for the plugin subdirectories.
   */

  /**
   * Defines directories where an additional plugin exists.
   */

  /**
   * Whether to enable all plugins.
   *
   * @note this is intended to be an undocumented setting.
   */

  constructor(rawConfig, env) {
    (0, _defineProperty2.default)(this, "initialize", void 0);
    (0, _defineProperty2.default)(this, "pluginSearchPaths", void 0);
    (0, _defineProperty2.default)(this, "additionalPluginPaths", void 0);
    (0, _defineProperty2.default)(this, "shouldEnableAllPlugins", void 0);
    this.initialize = rawConfig.initialize;
    this.pluginSearchPaths = env.pluginSearchPaths;
    this.additionalPluginPaths = rawConfig.paths;
    this.shouldEnableAllPlugins = (0, _lodash.get)(rawConfig, _constants.ENABLE_ALL_PLUGINS_CONFIG_PATH, false);
  }
}
exports.PluginsConfig = PluginsConfig;