"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StaticAssets = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class StaticAssets {
  constructor(basePath, cdnConfig) {
    var _cdnConfig$baseHref;
    (0, _defineProperty2.default)(this, "assetsHrefBase", void 0);
    const hrefToUse = (_cdnConfig$baseHref = cdnConfig.baseHref) !== null && _cdnConfig$baseHref !== void 0 ? _cdnConfig$baseHref : basePath.serverBasePath;
    this.assetsHrefBase = hrefToUse.endsWith('/') ? hrefToUse.slice(0, -1) : hrefToUse;
  }

  /**
   * Returns a href (hypertext reference) intended to be used as the base for constructing
   * other hrefs to static assets.
   */
  getHrefBase() {
    return this.assetsHrefBase;
  }
  getPluginAssetHref(pluginName, assetPath) {
    if (assetPath.startsWith('/')) {
      assetPath = assetPath.slice(1);
    }
    return `${this.assetsHrefBase}/plugins/${pluginName}/assets/${assetPath}`;
  }
}
exports.StaticAssets = StaticAssets;