"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthStateStorage = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreHttpServer = require("@kbn/core-http-server");
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
class AuthStateStorage {
  constructor(canBeAuthenticated) {
    (0, _defineProperty2.default)(this, "storage", new WeakMap());
    (0, _defineProperty2.default)(this, "set", (request, state) => {
      this.storage.set((0, _coreHttpRouterServerInternal.ensureRawRequest)(request), state);
    });
    (0, _defineProperty2.default)(this, "get", request => {
      const key = (0, _coreHttpRouterServerInternal.ensureRawRequest)(request);
      const state = this.storage.get(key);
      const status = this.storage.has(key) ? _coreHttpServer.AuthStatus.authenticated : this.canBeAuthenticated() ? _coreHttpServer.AuthStatus.unauthenticated : _coreHttpServer.AuthStatus.unknown;
      return {
        status,
        state
      };
    });
    (0, _defineProperty2.default)(this, "isAuthenticated", request => {
      return this.get(request).status === _coreHttpServer.AuthStatus.authenticated;
    });
    this.canBeAuthenticated = canBeAuthenticated;
  }
}
exports.AuthStateStorage = AuthStateStorage;