"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsAnchored = getIsAnchored;
exports.getRoundedTimeRangeBounds = getRoundedTimeRangeBounds;
var _time_utils = require("./time_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getRoundedTimeRangeBounds(state) {
  const stepSize = state.componentState.stepSize;
  const timeRangeBounds = state.componentState.timeRangeBounds;
  return [(0, _time_utils.roundDownToNextStepSizeFactor)(timeRangeBounds[_time_utils.FROM_INDEX], stepSize), (0, _time_utils.roundUpToNextStepSizeFactor)(timeRangeBounds[_time_utils.TO_INDEX], stepSize)];
}
function getIsAnchored(state) {
  return typeof state.explicitInput.isAnchored === 'boolean' ? state.explicitInput.isAnchored : false;
}